/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.component.inputfile.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.component.inputfile.InputFile;
import com.liferay.faces.bridge.component.inputfile.internal.InputFileDelegationResponseWriter;
import com.liferay.faces.bridge.component.inputfile.internal.InputFileRendererCompat;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.event.FileUploadEvent;
import com.liferay.faces.bridge.model.UploadedFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.render.FacesRenderer;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FacesRenderer(componentFamily="javax.faces.Input", rendererType="com.liferay.faces.bridge.component.inputfile.InputFileRenderer")
public class InputFileRenderer
extends InputFileRendererCompat {
    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String clientId;
        List<UploadedFile> uploadedFiles;
        InputFile inputFile = (InputFile)uiComponent;
        Map<String, List<UploadedFile>> uploadedFileMap = this.getUploadedFileMap(facesContext);
        if (uploadedFileMap != null && (uploadedFiles = uploadedFileMap.get(clientId = uiComponent.getClientId(facesContext))) != null && uploadedFiles.size() > 0) {
            ArrayList<UploadedFile> bridgeUploadedFiles = new ArrayList<UploadedFile>(uploadedFiles.size());
            for (UploadedFile uploadedFile : uploadedFiles) {
                bridgeUploadedFiles.add(uploadedFile);
            }
            inputFile.setSubmittedValue(bridgeUploadedFiles);
            for (UploadedFile uploadedFile : uploadedFiles) {
                FileUploadEvent fileUploadEvent = new FileUploadEvent(uiComponent, uploadedFile);
                uiComponent.queueEvent((FacesEvent)fileUploadEvent);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        InputFileDelegationResponseWriter delegationResponseWriter = new InputFileDelegationResponseWriter(responseWriter);
        super.encodeEnd(facesContext, uiComponent, (ResponseWriter)delegationResponseWriter);
    }

    protected Map<String, List<UploadedFile>> getUploadedFileMap(FacesContext facesContext) {
        ContextMapFactory contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory(ContextMapFactory.class);
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        return contextMapFactory.getUploadedFileMap(portletRequest);
    }
}

