/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.bean.internal;

import com.liferay.faces.bridge.bean.internal.PreDestroyInvokerImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.reflect.Method;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class PreDestroyInvokerMojarraImpl
extends PreDestroyInvokerImpl {
    private static final Logger logger = LoggerFactory.getLogger(PreDestroyInvokerMojarraImpl.class);
    private static final String INVOKE_PRE_DESTROY = "invokePreDestroy";
    private Method invokePreDestroyMethod;
    private Object mojarraInjectionProvider;

    public PreDestroyInvokerMojarraImpl(ServletContext servletContext) {
        this.init(new ContextAdapter(servletContext));
    }

    public PreDestroyInvokerMojarraImpl(PortletContext portletContext) {
        this.init(new ContextAdapter(portletContext));
    }

    public void invokeAnnotatedMethods(Object managedBean, boolean preferPreDestroy) {
        if (preferPreDestroy) {
            if (this.invokePreDestroyMethod != null) {
                try {
                    logger.debug("Invoking methods annotated with @PreDestroy: mojarraInjectionProvider=[{0}] managedBean=[{1}]", new Object[]{this.mojarraInjectionProvider, managedBean});
                    this.invokePreDestroyMethod.invoke(this.mojarraInjectionProvider, managedBean);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            } else {
                super.invokeAnnotatedMethods(managedBean, preferPreDestroy);
            }
        } else {
            super.invokeAnnotatedMethods(managedBean, preferPreDestroy);
        }
    }

    public String toString() {
        return this.mojarraInjectionProvider.toString();
    }

    protected Object getInjectionProvider(ContextAdapter contextAdapter) {
        try {
            Object applicationAssociate = contextAdapter.getAttribute("com.sun.faces.ApplicationAssociate");
            if (applicationAssociate != null) {
                Method getInjectionProviderMethod = applicationAssociate.getClass().getMethod("getInjectionProvider", new Class[0]);
                Object mojarraInjectionProvider = getInjectionProviderMethod.invoke(applicationAssociate, new Object[0]);
                logger.debug("mojarraInjectionProvider=[{0}]", new Object[]{mojarraInjectionProvider});
                return mojarraInjectionProvider;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    private void init(ContextAdapter contextAdapter) {
        this.mojarraInjectionProvider = this.getInjectionProvider(contextAdapter);
        try {
            this.invokePreDestroyMethod = this.mojarraInjectionProvider.getClass().getMethod(INVOKE_PRE_DESTROY, Object.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static class ContextAdapter {
        private PortletContext portletContext;
        private ServletContext servletContext;

        public ContextAdapter(PortletContext portletContext) {
            this.portletContext = portletContext;
        }

        public ContextAdapter(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public Object getAttribute(String name) {
            if (this.portletContext != null) {
                return this.portletContext.getAttribute(name);
            }
            if (this.servletContext != null) {
                return this.servletContext.getAttribute(name);
            }
            return null;
        }
    }
}

