/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.bean.internal;

import com.liferay.faces.bridge.bean.internal.PreDestroyInvoker;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class PreDestroyInvokerImpl
implements PreDestroyInvoker {
    private static final Logger logger = LoggerFactory.getLogger(PreDestroyInvokerImpl.class);

    public void invokeAnnotatedMethods(Object managedBean, boolean preferPreDestroy) {
        if (managedBean != null) {
            Class<?> clazz = managedBean.getClass();
            Method[] methods = managedBean.getClass().getMethods();
            if (methods != null) {
                for (Method method : methods) {
                    if (preferPreDestroy) {
                        if (!this.hasPreDestroyAnnotation(method)) continue;
                        try {
                            logger.debug("Invoking @PreDestroy method named [{0}] on managedBean class=[{1}]", new Object[]{method.getName(), clazz.getName()});
                            method.invoke(managedBean, new Object[0]);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), new Object[]{e});
                        }
                        continue;
                    }
                    if (!this.hasBridgePreDestroyAnnotation(method)) continue;
                    try {
                        logger.debug("Invoking @BridgePreDestroy method named [{0}] on managedBean class=[{1}]", new Object[]{method.getName(), clazz.getName()});
                        method.invoke(managedBean, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), new Object[]{e});
                    }
                }
            }
        }
    }

    protected boolean hasBridgePreDestroyAnnotation(Method method) {
        Annotation[] annotations;
        Class<?>[] parameterTypes;
        if (method.getReturnType() == Void.TYPE && ((parameterTypes = method.getParameterTypes()) == null || parameterTypes.length == 0) && (annotations = method.getAnnotations()) != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().getName().equals("javax.portlet.faces.annotation.BridgePreDestroy")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasPreDestroyAnnotation(Method method) {
        Annotation[] annotations;
        Class<?>[] parameterTypes;
        if (method.getReturnType() == Void.TYPE && ((parameterTypes = method.getParameterTypes()) == null || parameterTypes.length == 0) && (annotations = method.getAnnotations()) != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().getName().equals("javax.annotation.PreDestroy")) continue;
                return true;
            }
        }
        return false;
    }
}

