/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.ResourceHandlerBridgeImpl;
import com.liferay.faces.util.application.ResourceValidator;
import com.liferay.faces.util.application.ResourceValidatorFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ResourceHandlerInnerImpl
extends ResourceHandlerBridgeImpl {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHandlerInnerImpl.class);

    public ResourceHandlerInnerImpl(ResourceHandler resourceHandler) {
        super(resourceHandler);
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        String libraryName;
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String resourceName = (String)requestParameterMap.get("javax.faces.resource");
        if (resourceName == null) {
            resourceName = "";
        }
        if ((libraryName = (String)requestParameterMap.get("ln")) == null) {
            libraryName = "";
        }
        String resourceId = libraryName + "/" + resourceName;
        ResourceValidator resourceValidator = ResourceValidatorFactory.getResourceValidatorInstance();
        if (resourceValidator.containsBannedPath(resourceId)) {
            logger.warn("Invalid path for resourceId=[{0}]", new Object[]{resourceId});
            externalContext.setResponseStatus(404);
        } else if (resourceValidator.isBannedSequence(resourceId)) {
            logger.warn("Invalid sequence for resourceId=[{0}]", new Object[]{resourceId});
            externalContext.setResponseStatus(404);
        } else if (resourceValidator.isFaceletDocument(facesContext, resourceId)) {
            logger.warn("Invalid request for Facelet document resourceId=[{0}]", new Object[]{resourceId});
            externalContext.setResponseStatus(404);
        } else if (!resourceValidator.isValidResourceName(resourceName)) {
            logger.warn("Invalid request due to invalid resourceName=[{0}]", new Object[]{resourceName});
            externalContext.setResponseStatus(404);
        } else if (!resourceValidator.isValidLibraryName(libraryName)) {
            logger.warn("Invalid request due to invalid libraryName=[{0}]", new Object[]{libraryName});
            externalContext.setResponseStatus(404);
        } else {
            super.handleResourceRequest(facesContext);
        }
    }
}

