/**
 * Copyright (c) 2000-2016 Liferay, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.liferay.faces.bridge.filter.internal;

import java.io.Serializable;

import javax.portlet.PortletContext;

import com.liferay.faces.bridge.filter.BridgePortletContextFactory;


/**
 * @author  Neil Griffin
 */
public class BridgePortletContextFactoryImpl extends BridgePortletContextFactory implements Serializable {

	// serialVersionUID
	private static final long serialVersionUID = 167307858296513683L;

	@Override
	public PortletContext getPortletContext(PortletContext portletContext) {
		return portletContext;
	}

	public BridgePortletContextFactory getWrapped() {

		// Since this is the factory instance provided by the bridge, it will never wrap another factory.
		return null;
	}
}
