/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet.faces;

import com.liferay.faces.bridge.BridgeEventHandlerFactory;
import com.liferay.faces.bridge.BridgeEventHandlerWrapper;
import com.liferay.faces.bridge.BridgePublicRenderParameterHandlerFactory;
import com.liferay.faces.bridge.BridgePublicRenderParameterHandlerWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.BridgePublicRenderParameterHandler;

public class GenericFacesPortlet
extends GenericPortlet {
    public static final String BRIDGE_AUTO_DISPATCH_EVENTS = "javax.portlet.faces.autoDispatchEvents";
    public static final String BRIDGE_CLASS = "javax.portlet.faces.BridgeClassName";
    public static final String INITIALIZE_NAMESPACED_CONTEXT_ATTRIBUTES = "javax.portlet.faces.initializeNamespacedContextAttributes";
    public static final String BRIDGE_SERVICE_CLASSPATH = "META-INF/services/javax.portlet.faces.Bridge";
    @Deprecated
    public static final String DEFAULT_CONTENT_TYPE = "javax.portlet.faces.defaultContentType";
    @Deprecated
    public static final String DEFAULT_CHARACTERSET_ENCODING = "javax.portlet.faces.defaultCharacterSetEncoding";
    public static final String DEFAULT_VIEWID = "javax.portlet.faces.defaultViewId";
    private boolean autoDispatchEvents;
    private Bridge bridge;
    private String bridgeClassName;
    private Bridge bridgeService;
    private BridgeEventHandler bridgeEventHandler;
    private BridgePublicRenderParameterHandler bridgePublicRenderParameterHandler;
    private Map<String, String> defaultViewIdMap;
    private List<String> excludedRequestAttributes;
    private Boolean preserveActionParameters;

    public void destroy() {
        try {
            this.getBridge().destroy();
        }
        catch (PortletException e) {
            e.printStackTrace();
        }
    }

    public String getBridgeClassName() {
        if (this.bridgeClassName == null) {
            this.bridgeClassName = this.getPortletConfig().getInitParameter(BRIDGE_CLASS);
            if (this.bridgeClassName == null) {
                this.bridgeClassName = this.getBridgeService().getClass().getName();
            }
        }
        return this.bridgeClassName;
    }

    @Deprecated
    public BridgeEventHandler getBridgeEventHandler() throws PortletException {
        if (this.bridgeEventHandler == null) {
            String initParamName = "javax.portlet.faces.bridgeEventHandler";
            PortletConfig portletConfig = this.getPortletConfig();
            String bridgeEventHandlerClass = portletConfig.getInitParameter(initParamName);
            if (bridgeEventHandlerClass != null) {
                this.bridgeEventHandler = new DeferredBridgeEventHandler(portletConfig);
            }
        }
        return this.bridgeEventHandler;
    }

    @Deprecated
    public BridgePublicRenderParameterHandler getBridgePublicRenderParameterHandler() throws PortletException {
        if (this.bridgePublicRenderParameterHandler == null) {
            String initParamName = "javax.portlet.faces.bridgePublicRenderParameterHandler";
            PortletConfig portletConfig = this.getPortletConfig();
            String bridgePublicRenderParameterHandlerClass = portletConfig.getInitParameter(initParamName);
            if (bridgePublicRenderParameterHandlerClass != null) {
                this.bridgePublicRenderParameterHandler = new DeferredBridgePublicRenderParameterHandler(portletConfig);
            }
        }
        return this.bridgePublicRenderParameterHandler;
    }

    @Deprecated
    public String getDefaultRenderKitId() {
        return this.getPortletConfig().getInitParameter("javax.portlet.faces.defaultRenderKitId");
    }

    @Deprecated
    public Map<String, String> getDefaultViewIdMap() {
        if (this.defaultViewIdMap == null) {
            this.defaultViewIdMap = new HashMap<String, String>();
            Enumeration initParameterNames = this.getPortletConfig().getInitParameterNames();
            if (initParameterNames != null) {
                int defaultViewIdLength = DEFAULT_VIEWID.length();
                int portletModeIndex = defaultViewIdLength + 1;
                while (initParameterNames.hasMoreElements()) {
                    String initParameterName = (String)initParameterNames.nextElement();
                    if (initParameterName == null || !initParameterName.startsWith(DEFAULT_VIEWID) || initParameterName.length() <= defaultViewIdLength) continue;
                    String initParameterValue = this.getPortletConfig().getInitParameter(initParameterName);
                    String portletMode = initParameterName.substring(portletModeIndex);
                    this.defaultViewIdMap.put(portletMode, initParameterValue);
                }
            }
        }
        return this.defaultViewIdMap;
    }

    @Deprecated
    public List<String> getExcludedRequestAttributes() {
        if (this.excludedRequestAttributes == null) {
            String initParamName = "javax.portlet.faces.excludedRequestAttributes";
            String initParamValue = this.getPortletConfig().getInitParameter(initParamName);
            if (initParamValue != null) {
                String[] values;
                this.excludedRequestAttributes = new ArrayList<String>();
                for (String value : values = initParamValue.split(",")) {
                    this.excludedRequestAttributes.add(value.trim());
                }
            }
        }
        return this.excludedRequestAttributes;
    }

    public Bridge getFacesBridge(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
        String viewId = portletRequest.getParameter("_jsfBridgeViewId");
        if (viewId != null) {
            portletRequest.setAttribute("javax.portlet.faces.viewId", (Object)viewId);
        } else {
            String viewPath = portletRequest.getParameter("_jsfBridgeViewPath");
            if (viewPath != null) {
                portletRequest.setAttribute("javax.portlet.faces.viewPath", (Object)viewPath);
            }
        }
        return this.getBridge();
    }

    @Deprecated
    public String getResponseCharacterSetEncoding(PortletRequest portletRequest) {
        return null;
    }

    @Deprecated
    public String getResponseContentType(PortletRequest portletRequest) {
        return portletRequest.getResponseContentType();
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        String initParamValue;
        String portletName = portletConfig.getPortletName();
        super.init(portletConfig);
        this.getBridge().init(portletConfig);
        String initParam = portletConfig.getInitParameter(INITIALIZE_NAMESPACED_CONTEXT_ATTRIBUTES);
        boolean initializeNamespacedContextAttributes = "true".equalsIgnoreCase(initParam);
        if (initializeNamespacedContextAttributes) {
            String defaultRenderKitId;
            BridgePublicRenderParameterHandler bridgePublicRenderParameterHandlerInstance;
            PortletContext portletContext = portletConfig.getPortletContext();
            String attributeName = "javax.portlet.faces." + portletName + "." + "defaultViewIdMap";
            portletContext.setAttribute(attributeName, this.getDefaultViewIdMap());
            attributeName = "javax.portlet.faces." + portletName + "." + "excludedRequestAttributes";
            portletContext.setAttribute(attributeName, this.getExcludedRequestAttributes());
            attributeName = "javax.portlet.faces." + portletName + "." + "preserveActionParams";
            portletContext.setAttribute(attributeName, (Object)this.isPreserveActionParameters());
            BridgeEventHandler bridgeEventHandlerInstance = this.getBridgeEventHandler();
            if (bridgeEventHandlerInstance != null) {
                attributeName = "javax.portlet.faces." + portletConfig.getPortletName() + "." + "bridgeEventHandler";
                portletContext.setAttribute(attributeName, (Object)bridgeEventHandlerInstance);
            }
            if ((bridgePublicRenderParameterHandlerInstance = this.getBridgePublicRenderParameterHandler()) != null) {
                String bridgeEventHandlerAttributeName = "javax.portlet.faces." + portletConfig.getPortletName() + "." + "bridgePublicRenderParameterHandler";
                portletContext.setAttribute(bridgeEventHandlerAttributeName, (Object)bridgePublicRenderParameterHandlerInstance);
            }
            if ((defaultRenderKitId = this.getDefaultRenderKitId()) != null) {
                portletContext.setAttribute("javax.portlet.faces." + portletConfig.getPortletName() + "." + "defaultRenderKitId", (Object)defaultRenderKitId);
            }
        }
        this.autoDispatchEvents = (initParamValue = portletConfig.getInitParameter(BRIDGE_AUTO_DISPATCH_EVENTS)) == null || Boolean.parseBoolean(initParamValue);
    }

    public boolean isAutoDispatchEvents() {
        return this.autoDispatchEvents;
    }

    @Deprecated
    public boolean isPreserveActionParameters() {
        if (this.preserveActionParameters == null) {
            String initParamName = "javax.portlet.faces.preserveActionParams";
            String initParamValue = this.getPortletConfig().getInitParameter(initParamName);
            this.preserveActionParameters = initParamValue != null ? Boolean.valueOf(Boolean.parseBoolean(initParamValue)) : Boolean.FALSE;
        }
        return this.preserveActionParameters;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        bridge.doFacesRequest(actionRequest, actionResponse);
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws PortletException, IOException {
        if (this.isAutoDispatchEvents()) {
            Bridge bridge = this.getFacesBridge((PortletRequest)eventRequest, (PortletResponse)eventResponse);
            bridge.doFacesRequest(eventRequest, eventResponse);
        } else {
            super.processEvent(eventRequest, eventResponse);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        bridge.doFacesRequest(resourceRequest, resourceResponse);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        String autoNonFacesViewDispatch = this.getInitParameter("javax.portlet.faces.automaticNonFacesViewDispatching");
        String nonFacesTargetPath = renderRequest.getParameter("_jsfBridgeNonFacesView");
        if (autoNonFacesViewDispatch != null && autoNonFacesViewDispatch.equalsIgnoreCase("true") && nonFacesTargetPath != null) {
            PortletContext portletContext = this.getPortletContext();
            String responseContentType = renderRequest.getResponseContentType();
            renderResponse.setContentType(responseContentType);
            PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher(nonFacesTargetPath);
            try {
                portletRequestDispatcher.forward((PortletRequest)renderRequest, (PortletResponse)renderResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        bridge.doFacesRequest(renderRequest, renderResponse);
    }

    protected void doHeaders(RenderRequest renderRequest, RenderResponse renderResponse) {
        try {
            Object renderPartAttribute = renderRequest.getAttribute("javax.portlet.render_part");
            if (renderPartAttribute != null && renderPartAttribute.equals("RENDER_HEADERS")) {
                Bridge bridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
                bridge.doFacesRequest(renderRequest, renderResponse);
            }
        }
        catch (PortletException e) {
            e.printStackTrace();
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        bridge.doFacesRequest(renderRequest, renderResponse);
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        bridge.doFacesRequest(renderRequest, renderResponse);
    }

    private Bridge getBridge() throws PortletException {
        if (this.bridge == null) {
            this.bridge = this.getBridgeService();
            String bridgeClassName = this.getBridgeClassName();
            if (!this.bridge.getClass().getName().equals(bridgeClassName)) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> bridgeClass = classLoader.loadClass(bridgeClassName);
                    this.bridge = (Bridge)bridgeClass.newInstance();
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
        }
        return this.bridge;
    }

    private Bridge getBridgeService() {
        if (this.bridgeService == null) {
            ServiceLoader<Bridge> serviceLoader = ServiceLoader.load(Bridge.class);
            Iterator<Bridge> iterator = serviceLoader.iterator();
            while (this.bridgeService == null && iterator.hasNext()) {
                this.bridgeService = iterator.next();
            }
        }
        return this.bridgeService;
    }

    private static class DeferredBridgePublicRenderParameterHandler
    extends BridgePublicRenderParameterHandlerWrapper {
        private PortletConfig portletConfig;
        private volatile BridgePublicRenderParameterHandler wrappedBridgePublicRenderParameterHandler;

        public DeferredBridgePublicRenderParameterHandler(PortletConfig portletConfig) {
            this.portletConfig = portletConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BridgePublicRenderParameterHandler getWrapped() {
            BridgePublicRenderParameterHandler bridgePublicRenderParameterHandler = this.wrappedBridgePublicRenderParameterHandler;
            if (bridgePublicRenderParameterHandler == null) {
                DeferredBridgePublicRenderParameterHandler deferredBridgePublicRenderParameterHandler = this;
                synchronized (deferredBridgePublicRenderParameterHandler) {
                    bridgePublicRenderParameterHandler = this.wrappedBridgePublicRenderParameterHandler;
                    if (bridgePublicRenderParameterHandler == null) {
                        bridgePublicRenderParameterHandler = this.wrappedBridgePublicRenderParameterHandler = BridgePublicRenderParameterHandlerFactory.getBridgePublicRenderParameterHandlerInstance(this.portletConfig);
                    }
                }
            }
            return bridgePublicRenderParameterHandler;
        }
    }

    private static class DeferredBridgeEventHandler
    extends BridgeEventHandlerWrapper {
        private PortletConfig portletConfig;
        private volatile BridgeEventHandler wrappedBridgeEventHandler;

        public DeferredBridgeEventHandler(PortletConfig portletConfig) {
            this.portletConfig = portletConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BridgeEventHandler getWrapped() {
            BridgeEventHandler bridgeEventHandler = this.wrappedBridgeEventHandler;
            if (bridgeEventHandler == null) {
                DeferredBridgeEventHandler deferredBridgeEventHandler = this;
                synchronized (deferredBridgeEventHandler) {
                    bridgeEventHandler = this.wrappedBridgeEventHandler;
                    if (bridgeEventHandler == null) {
                        bridgeEventHandler = this.wrappedBridgeEventHandler = BridgeEventHandlerFactory.getBridgeEventHandlerInstance(this.portletConfig);
                    }
                }
            }
            return bridgeEventHandler;
        }
    }
}

