/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.faces.FacesException;

public abstract class BridgeFactoryFinder {
    public static Object getFactory(Class<?> clazz) {
        return BridgeFactoryFinder.getInstance().getFactoryInstance(clazz);
    }

    public static BridgeFactoryFinder getInstance() throws FacesException {
        return OnDemandBridgeFactoryFinder.instance;
    }

    public abstract Object getFactoryInstance(Class<?> var1);

    private static class OnDemandBridgeFactoryFinder {
        private static final BridgeFactoryFinder instance;

        private OnDemandBridgeFactoryFinder() {
            throw new AssertionError();
        }

        static {
            ServiceLoader<BridgeFactoryFinder> serviceLoader = ServiceLoader.load(BridgeFactoryFinder.class);
            Iterator<BridgeFactoryFinder> iterator = serviceLoader.iterator();
            BridgeFactoryFinder bridgeFactoryFinder = null;
            while (bridgeFactoryFinder == null && iterator.hasNext()) {
                bridgeFactoryFinder = iterator.next();
            }
            if (bridgeFactoryFinder == null) {
                throw new FacesException("Unable locate service for " + BridgeFactoryFinder.class.getName());
            }
            instance = bridgeFactoryFinder;
        }
    }
}

