/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.util;

import com.liferay.content.targeting.model.Tactic;
import com.liferay.content.targeting.service.TacticLocalServiceUtil;
import com.liferay.content.targeting.util.BaseModelSearchResult;
import com.liferay.content.targeting.util.SearchContainerIterator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class TacticSearchContainerIterator
extends SearchContainerIterator<Tactic> {
    private final long _campaignId;

    public TacticSearchContainerIterator() {
        this._campaignId = 0L;
    }

    public TacticSearchContainerIterator(long campaignId, long groupId, String keywords) {
        super(groupId, keywords);
        this._campaignId = campaignId;
    }

    @Override
    public List<Tactic> getResults(int start, int end) throws PortalException {
        if (Validator.isNull((String)this.keywords)) {
            return TacticLocalServiceUtil.getTactics(this._campaignId, start, end, null);
        }
        BaseModelSearchResult<Tactic> searchResults = TacticLocalServiceUtil.searchTactics(this._campaignId, this.groupId, this.keywords, start, end);
        return searchResults.getBaseModels();
    }

    public List<Tactic> getResults(long campaignId, int start, int end) throws PortalException {
        if (Validator.isNull((String)this.keywords)) {
            return TacticLocalServiceUtil.getTactics(campaignId, start, end, null);
        }
        BaseModelSearchResult<Tactic> searchResults = TacticLocalServiceUtil.searchTactics(campaignId, this.groupId, this.keywords, start, end);
        return searchResults.getBaseModels();
    }

    @Override
    public int getTotal() throws PortalException {
        if (Validator.isNull((String)this.keywords)) {
            return TacticLocalServiceUtil.getTacticsCount(this._campaignId);
        }
        BaseModelSearchResult<Tactic> searchResults = TacticLocalServiceUtil.searchTactics(this._campaignId, this.groupId, this.keywords, -1, -1);
        return searchResults.getLength();
    }

    public int getTotal(long campaignId) throws PortalException {
        if (Validator.isNull((String)this.keywords)) {
            return TacticLocalServiceUtil.getTacticsCount(campaignId);
        }
        BaseModelSearchResult<Tactic> searchResults = TacticLocalServiceUtil.searchTactics(campaignId, this.groupId, this.keywords, -1, -1);
        return searchResults.getLength();
    }
}

