/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.util.comparator.AssetRendererFactoryTypeNameComparator;
import com.liferay.content.targeting.model.UserSegment;
import com.liferay.content.targeting.service.UserSegmentLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class ContentTargetingUtil {
    public static final String GUID_REPLACEMENT = "{ct_field_guid}";
    private static final String _CATEGORY_SEPARATOR = "_CATEGORY_";

    public static String escapeAttribute(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        String prefix = "&#x";
        String postfix = ";";
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c > '\u00ff' || c == '-' || c == '_' || Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append(prefix);
            String hexString = StringUtil.toHexString((int)c);
            if (hexString.length() == 1) {
                sb.append(StringPool.ASCII_TABLE[48]);
            }
            sb.append(hexString);
            sb.append(postfix);
        }
        if (sb.length() == text.length()) {
            return text;
        }
        return sb.toString();
    }

    public static long[] getAncestorsAndCurrentGroupIds(long groupId) throws PortalException {
        Group scopeGroup = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (scopeGroup == null) {
            return null;
        }
        String stagedPortletId = StagingUtil.getStagedPortletId((String)PortletConstants.getRootPortletId((String)"com_liferay_content_targeting_web_portlet_ContentTargetingPortlet"));
        if (scopeGroup.isStagingGroup() && !scopeGroup.isStagedPortlet(stagedPortletId)) {
            scopeGroup = scopeGroup.getLiveGroup();
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.addAll(scopeGroup.getAncestors());
        groups.add(scopeGroup);
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)scopeGroup.getCompanyId());
        groups.add(companyGroup);
        long[] groupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.get(i);
            groupIds[i] = group.getGroupId();
        }
        return groupIds;
    }

    public static long[] getAssetCategoryIds(List<UserSegment> userSegments) {
        long[] assetCategoryIds = new long[userSegments.size()];
        for (int i = 0; i < assetCategoryIds.length; ++i) {
            UserSegment userSegment = userSegments.get(i);
            assetCategoryIds[i] = userSegment.getAssetCategoryId();
        }
        return assetCategoryIds;
    }

    public static long[] getAssetCategoryIds(long groupId, long[] userSegmentIds) {
        if (userSegmentIds == null) {
            return new long[0];
        }
        long[] assetCategoryIds = new long[userSegmentIds.length];
        for (int i = 0; i < userSegmentIds.length; ++i) {
            UserSegment userSegment = UserSegmentLocalServiceUtil.fetchUserSegment(userSegmentIds[i]);
            if (userSegment == null) continue;
            assetCategoryIds[i] = userSegment.getAssetCategoryId(groupId);
        }
        return assetCategoryIds;
    }

    public static String getAssetCategoryNames(long[] assetCategoryIds, Locale locale) {
        return ContentTargetingUtil.getAssetCategoryNames(assetCategoryIds, locale, _CATEGORY_SEPARATOR);
    }

    public static String getAssetCategoryNames(long[] assetCategoryIds, Locale locale, String separator) {
        if (ArrayUtil.isEmpty((long[])assetCategoryIds)) {
            return "";
        }
        StringBundler sb = new StringBundler(assetCategoryIds.length * 2 - 1);
        for (int i = 0; i < assetCategoryIds.length; ++i) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)assetCategoryIds[i]);
            if (assetCategory == null) continue;
            sb.append(assetCategory.getTitle(locale));
            if (i == assetCategoryIds.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static List<AssetRendererFactory<?>> getAssetRendererFactories(HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List assetRendererFactories = AssetRendererFactoryRegistryUtil.getAssetRendererFactories((long)themeDisplay.getCompanyId());
        assetRendererFactories = ListUtil.filter((List)assetRendererFactories, (PredicateFilter)new PredicateFilter<AssetRendererFactory<?>>(){

            public boolean filter(AssetRendererFactory<?> assetRendererFactory) {
                return assetRendererFactory.isLinkable() && assetRendererFactory.isSelectable();
            }
        });
        return ListUtil.sort((List)assetRendererFactories, (Comparator)new AssetRendererFactoryTypeNameComparator(themeDisplay.getLocale()));
    }

    public static Map<String, Object> getAssetSelectorIconData(HttpServletRequest request, AssetRendererFactory assetRendererFactory, String index) throws Exception {
        return ContentTargetingUtil.getAssetSelectorIconData(request, assetRendererFactory, index, false);
    }

    public static Map<String, Object> getAssetSelectorIconData(HttpServletRequest request, AssetRendererFactory assetRendererFactory, String index, boolean instantiable) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL assetBrowserURL = ContentTargetingUtil.getAssetBrowserURL(request, assetRendererFactory.getClassName(), instantiable);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("groupid", String.valueOf(themeDisplay.getScopeGroupId()));
        data.put("href", assetBrowserURL.toString());
        if (!Validator.isBlank((String)index)) {
            data.put("index", index);
        }
        String typeName = assetRendererFactory.getTypeName(themeDisplay.getLocale());
        data.put("title", LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"select-x", (Object)typeName, (boolean)false));
        data.put("type", typeName);
        return data;
    }

    public static String getCategorySeparator() {
        return _CATEGORY_SEPARATOR;
    }

    public static String getDescription(Class<?> clazz, Locale locale) {
        String key = clazz.getName().concat(".description");
        String description = ContentTargetingUtil.getModelResource(locale, clazz, key);
        if (description.endsWith(key)) {
            description = ContentTargetingUtil.getShortDescription(clazz, locale);
        }
        return description;
    }

    public static String getModelResource(Locale locale, Class clazz, String name) {
        String key = ResourceActionsUtil.getModelResourceNamePrefix() + name;
        try {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, (Class)clazz);
            String modelResource = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
            if (modelResource == null) {
                modelResource = key;
            }
            return modelResource;
        }
        catch (MissingResourceException mre) {
            return ResourceActionsUtil.getModelResource((Locale)locale, (String)name);
        }
    }

    public static String getName(Class<?> clazz, Locale locale) {
        return ContentTargetingUtil.getModelResource(locale, clazz, clazz.getName());
    }

    public static List<Map<String, Object>> getSelectorEntries(HttpServletRequest request, ResourceBundle resourceBundle, String index, boolean instantiable) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<Map<String, Object>> selectorEntries = new ArrayList<Map<String, Object>>();
        for (AssetRendererFactory<?> assetRendererFactory : ContentTargetingUtil.getAssetRendererFactories(request)) {
            if (assetRendererFactory.isSupportsClassTypes()) {
                selectorEntries.addAll(ContentTargetingUtil._getSelectorEntries(assetRendererFactory, request, resourceBundle, themeDisplay, index, instantiable));
                continue;
            }
            HashMap<String, Object> selectorEntry = new HashMap<String, Object>();
            selectorEntry.put("data", ContentTargetingUtil._getSelectorEntryData(assetRendererFactory, request, resourceBundle, themeDisplay, index, instantiable));
            selectorEntry.put("iconCssClass", ContentTargetingUtil._getSelectorEntryIconCssClass(assetRendererFactory));
            selectorEntry.put("id", ContentTargetingUtil._getSelectorEntryId(assetRendererFactory, themeDisplay, index));
            selectorEntry.put("message", ContentTargetingUtil._getSelectorEntryMessage(assetRendererFactory, themeDisplay));
            selectorEntries.add(selectorEntry);
        }
        return selectorEntries;
    }

    public static String getShortDescription(Class<?> clazz, Locale locale) {
        String key = clazz.getName().concat(".shortDescription");
        String shortDescription = ContentTargetingUtil.getModelResource(locale, clazz, key);
        if (shortDescription.endsWith(key)) {
            shortDescription = "";
        }
        return shortDescription;
    }

    protected static PortletURL getAssetBrowserURL(HttpServletRequest request, String className, boolean instantiable) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL assetBrowserURL = PortletProviderUtil.getPortletURL((HttpServletRequest)request, (String)className, (PortletProvider.Action)PortletProvider.Action.BROWSE);
        assetBrowserURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
        assetBrowserURL.setParameter("selectedGroupIds", StringUtil.merge((long[])PortalUtil.getSharedContentSiteGroupIds((long)themeDisplay.getCompanyId(), (long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId())));
        assetBrowserURL.setParameter("showNonindexable", String.valueOf(Boolean.TRUE));
        String eventName = "selectContent";
        if (instantiable) {
            eventName = "_{ct_field_guid}_" + eventName;
        }
        assetBrowserURL.setParameter("eventName", eventName);
        assetBrowserURL.setParameter("typeSelection", className);
        assetBrowserURL.setPortletMode(PortletMode.VIEW);
        assetBrowserURL.setWindowState(LiferayWindowState.POP_UP);
        return assetBrowserURL;
    }

    private static long _getAssetBrowserGroupId(AssetRendererFactory<?> assetRendererFactory, ThemeDisplay themeDisplay) {
        Group scopeGroup = themeDisplay.getScopeGroup();
        boolean stagedLocally = false;
        boolean stagedReferrerPortlet = false;
        if (scopeGroup.isStaged() && !scopeGroup.isStagedRemotely()) {
            stagedLocally = true;
            stagedReferrerPortlet = scopeGroup.isStagedPortlet(assetRendererFactory.getPortletId());
        }
        long groupId = scopeGroup.getGroupId();
        if (stagedLocally && scopeGroup.isStagingGroup()) {
            boolean stagedReferencePortlet = scopeGroup.isStagedPortlet(assetRendererFactory.getPortletId());
            if (stagedReferrerPortlet && !stagedReferencePortlet) {
                groupId = scopeGroup.getLiveGroupId();
            }
        }
        return groupId;
    }

    private static PortletURL _getAssetBrowserPortletURL(AssetRendererFactory<?> assetRendererFactory, HttpServletRequest request, ThemeDisplay themeDisplay, boolean instantiable) throws Exception {
        PortletURL portletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)request, (String)assetRendererFactory.getClassName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
        if (portletURL == null) {
            return portletURL;
        }
        long groupId = ContentTargetingUtil._getAssetBrowserGroupId(assetRendererFactory, themeDisplay);
        String eventName = "selectContent";
        if (instantiable) {
            eventName = "_{ct_field_guid}_selectContent";
        }
        portletURL.setParameter("eventName", eventName);
        portletURL.setParameter("groupId", String.valueOf(groupId));
        portletURL.setParameter("selectedGroupIds", StringUtil.merge((long[])PortalUtil.getSharedContentSiteGroupIds((long)themeDisplay.getCompanyId(), (long)groupId, (long)themeDisplay.getUserId())));
        portletURL.setParameter("showNonindexable", String.valueOf(Boolean.TRUE));
        portletURL.setParameter("typeSelection", assetRendererFactory.getClassName());
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return portletURL;
    }

    private static List<Map<String, Object>> _getSelectorEntries(AssetRendererFactory<?> assetRendererFactory, HttpServletRequest request, ResourceBundle resourceBundle, ThemeDisplay themeDisplay, String index, boolean instantiable) throws Exception {
        long groupId = ContentTargetingUtil._getAssetBrowserGroupId(assetRendererFactory, themeDisplay);
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        List classTypes = classTypeReader.getAvailableClassTypes(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId), themeDisplay.getLocale());
        if (classTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> selectorEntries = new ArrayList<Map<String, Object>>();
        for (ClassType classType : classTypes) {
            HashMap<String, Object> selectorEntry = new HashMap<String, Object>();
            selectorEntry.put("data", ContentTargetingUtil._getSelectorEntryData(assetRendererFactory, request, resourceBundle, themeDisplay, classType, index, instantiable));
            selectorEntry.put("iconCssClass", ContentTargetingUtil._getSelectorEntryIconCssClass(assetRendererFactory));
            selectorEntry.put("id", ContentTargetingUtil._getSelectorEntryId(classType, index));
            selectorEntry.put("message", ContentTargetingUtil._getSelectorEntryMessage(classType));
            selectorEntries.add(selectorEntry);
        }
        return selectorEntries;
    }

    private static Map<String, Object> _getSelectorEntryData(AssetRendererFactory<?> assetRendererFactory, HttpServletRequest request, ResourceBundle resourceBundle, ThemeDisplay themeDisplay, ClassType classType, String index, boolean instantiable) throws Exception {
        HashMap<String, Object> selectorEntryData = new HashMap<String, Object>();
        PortletURL portletURL = ContentTargetingUtil._getAssetBrowserPortletURL(assetRendererFactory, request, themeDisplay, instantiable);
        if (portletURL != null) {
            portletURL.setParameter("subtypeSelectionId", String.valueOf(classType.getClassTypeId()));
            selectorEntryData.put("href", portletURL.toString());
        }
        selectorEntryData.put("constrain", true);
        selectorEntryData.put("destroyOnHide", true);
        selectorEntryData.put("groupid", String.valueOf(themeDisplay.getScopeGroupId()));
        if (!Validator.isBlank((String)index)) {
            selectorEntryData.put("index", index);
        }
        selectorEntryData.put("modal", true);
        selectorEntryData.put("title", LanguageUtil.format((ResourceBundle)resourceBundle, (String)"select-x", (Object)classType.getName(), (boolean)false));
        selectorEntryData.put("type", classType.getName());
        return selectorEntryData;
    }

    private static Map<String, Object> _getSelectorEntryData(AssetRendererFactory<?> assetRendererFactory, HttpServletRequest request, ResourceBundle resourceBundle, ThemeDisplay themeDisplay, String index, boolean instantiable) throws Exception {
        HashMap<String, Object> selectorEntryData = new HashMap<String, Object>();
        PortletURL assetBrowserPortletURL = ContentTargetingUtil._getAssetBrowserPortletURL(assetRendererFactory, request, themeDisplay, instantiable);
        if (assetBrowserPortletURL != null) {
            selectorEntryData.put("href", assetBrowserPortletURL.toString());
        }
        String typeName = assetRendererFactory.getTypeName(themeDisplay.getLocale());
        selectorEntryData.put("constrain", true);
        selectorEntryData.put("destroyOnHide", true);
        selectorEntryData.put("groupid", String.valueOf(themeDisplay.getScopeGroupId()));
        if (!Validator.isBlank((String)index)) {
            selectorEntryData.put("index", index);
        }
        selectorEntryData.put("modal", true);
        selectorEntryData.put("title", LanguageUtil.format((ResourceBundle)resourceBundle, (String)"select-x", (Object)typeName, (boolean)false));
        selectorEntryData.put("type", assetRendererFactory.getTypeName(themeDisplay.getLocale()));
        return selectorEntryData;
    }

    private static String _getSelectorEntryIconCssClass(AssetRendererFactory<?> assetRendererFactory) {
        return assetRendererFactory.getIconCssClass();
    }

    private static String _getSelectorEntryId(AssetRendererFactory<?> assetRendererFactory, ThemeDisplay themeDisplay, String index) {
        String selectorEntryId = "groupId_";
        selectorEntryId = selectorEntryId + FriendlyURLNormalizerUtil.normalize((String)assetRendererFactory.getTypeName(themeDisplay.getLocale()));
        selectorEntryId = selectorEntryId + "_" + index;
        return selectorEntryId;
    }

    private static String _getSelectorEntryId(ClassType classType, String index) {
        String selectorEntryId = "groupId_";
        selectorEntryId = selectorEntryId + FriendlyURLNormalizerUtil.normalize((String)classType.getName());
        selectorEntryId = selectorEntryId + "_" + index;
        return selectorEntryId;
    }

    private static String _getSelectorEntryMessage(AssetRendererFactory<?> assetRendererFactory, ThemeDisplay themeDisplay) {
        return assetRendererFactory.getTypeName(themeDisplay.getLocale());
    }

    private static String _getSelectorEntryMessage(ClassType classType) {
        return classType.getName();
    }
}

