/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.taglib.aui.ValidatorTag;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ClassResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContentTargetingContextUtil {
    private static final Log _log = LogFactoryUtil.getLog(ContentTargetingContextUtil.class);

    public static Map<String, String> getJSONValues(JSONArray data, String namespace, String id) {
        HashMap<String, String> values = new HashMap<String, String>(data.length());
        for (int i = 0; i < data.length(); ++i) {
            JSONObject jsonObject = data.getJSONObject(i);
            String name = jsonObject.getString("name");
            name = StringUtil.replace((String)name, (String[])new String[]{namespace, id}, (String[])new String[]{"", ""});
            values.put(name, jsonObject.getString("value"));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String includeJSP(ServletContext servletContext, String path, Map<String, Object> context) throws Exception {
        if (Validator.isNull((String)path)) {
            _log.error((Object)("Cannot find path " + path));
            return "";
        }
        HttpServletRequest request = (HttpServletRequest)context.get("request");
        HttpServletResponse response = (HttpServletResponse)context.get("response");
        request.setAttribute("context", context);
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        BufferCacheServletResponse bufferResponse = new BufferCacheServletResponse(response);
        ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)request.getAttribute("RESOURCE_BUNDLE_LOADER");
        try {
            request.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)ContentTargetingContextUtil.getResourceBundleLoader(servletContext.getClassLoader(), (ResourceBundleLoader)context.get("portletResourceBundleLoader")));
            requestDispatcher.include((ServletRequest)request, (ServletResponse)bufferResponse);
            String string = bufferResponse.getString();
            return string;
        }
        catch (ServletException se) {
            _log.error((Object)("Unable to include " + path), (Throwable)se);
        }
        finally {
            request.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)resourceBundleLoader);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseTemplate(Class clazz, String templatePath, Map<String, Object> context) throws Exception {
        if (!templatePath.startsWith("/")) {
            templatePath = "/" + templatePath;
        }
        URLTemplateResource urlTemplateResource = new URLTemplateResource(templatePath, clazz.getResource(templatePath));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        ClassLoader resourceBundleClassLoader = (ClassLoader)context.get("resourceBundleClassLoader");
        if (resourceBundleClassLoader == null) {
            resourceBundleClassLoader = clazz.getClassLoader();
        }
        HttpServletRequest request = (HttpServletRequest)context.get("request");
        HttpServletResponse response = (HttpServletResponse)context.get("response");
        template.prepare(request);
        template.putAll(context);
        ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)request.getAttribute("RESOURCE_BUNDLE_LOADER");
        try {
            request.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)ContentTargetingContextUtil.getResourceBundleLoader(resourceBundleClassLoader, (ResourceBundleLoader)context.get("portletResourceBundleLoader")));
            TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)"ftl");
            templateManager.addTaglibSupport((Map)template, request, response);
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            template.processTemplate((Writer)unsyncStringWriter);
            String string = unsyncStringWriter.toString();
            return string;
        }
        finally {
            request.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)resourceBundleLoader);
        }
    }

    public static String processExceptions(List exceptions, Class clazz, Map<String, Object> context) {
        if (Validator.isNull((Object)exceptions)) {
            return "";
        }
        try {
            context.put("exceptions", exceptions);
            context.put("resourceBundleClassLoader", clazz.getClassLoader());
            Class portletClass = (Class)context.get("portletClass");
            return ContentTargetingContextUtil.parseTemplate(portletClass, "templates/ct_exceptions.ftl", context);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return "";
        }
    }

    public static String processValidators(Map<String, List<ValidatorTag>> validatorTagsMap, Class clazz, Map<String, Object> context) {
        if (Validator.isNull(validatorTagsMap)) {
            return "";
        }
        try {
            context.put("validatorTagsMap", validatorTagsMap);
            context.put("resourceBundleClassLoader", clazz.getClassLoader());
            Class portletClass = (Class)context.get("portletClass");
            return ContentTargetingContextUtil.parseTemplate(portletClass, "templates/ct_validators.ftl", context);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return "";
        }
    }

    protected static ResourceBundleLoader getResourceBundleLoader(ClassLoader classLoader, ResourceBundleLoader portletResourceBundleLoader) {
        return new AggregateResourceBundleLoader(new ResourceBundleLoader[]{new ClassResourceBundleLoader("content.Language", classLoader), portletResourceBundleLoader});
    }
}

