/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.exception;

import com.liferay.content.targeting.exception.InvalidTrackingActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvalidTrackingActionsException
extends PortalException {
    private final Map<String, List<InvalidTrackingActionException>> _exceptionsMap = new HashMap<String, List<InvalidTrackingActionException>>();

    public InvalidTrackingActionsException() {
    }

    public InvalidTrackingActionsException(List<InvalidTrackingActionException> exceptions) {
        if (Validator.isNull(exceptions)) {
            return;
        }
        for (InvalidTrackingActionException exception : exceptions) {
            String guid = exception.getTrackingActionGuid();
            List<InvalidTrackingActionException> exceptionList = new ArrayList<InvalidTrackingActionException>();
            if (this._exceptionsMap.containsKey(guid)) {
                exceptionList = this._exceptionsMap.get(guid);
            }
            exceptionList.add(exception);
            this._exceptionsMap.put(exception.getTrackingActionGuid(), exceptionList);
        }
    }

    public InvalidTrackingActionsException(String msg) {
        super(msg);
    }

    public InvalidTrackingActionsException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public void add(InvalidTrackingActionException exception) {
        List<InvalidTrackingActionException> exceptions = this._exceptionsMap.get(exception.getTrackingActionGuid());
        if (exceptions == null) {
            exceptions = new ArrayList<InvalidTrackingActionException>();
        }
        exceptions.add(exception);
        this._exceptionsMap.put(exception.getTrackingActionGuid(), exceptions);
    }

    public List<InvalidTrackingActionException> getExceptions(String trackingActionId) {
        return this._exceptionsMap.get(trackingActionId);
    }
}

