/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.exception;

import com.liferay.content.targeting.exception.InvalidRuleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvalidRulesException
extends PortalException {
    private final Map<String, List<InvalidRuleException>> _exceptionsMap = new HashMap<String, List<InvalidRuleException>>();

    public InvalidRulesException() {
    }

    public InvalidRulesException(List<InvalidRuleException> exceptions) {
        if (Validator.isNull(exceptions)) {
            return;
        }
        for (InvalidRuleException exception : exceptions) {
            String guid = exception.getRuleGuid();
            List<InvalidRuleException> exceptionList = new ArrayList<InvalidRuleException>();
            if (this._exceptionsMap.containsKey(guid)) {
                exceptionList = this._exceptionsMap.get(guid);
            }
            exceptionList.add(exception);
            this._exceptionsMap.put(exception.getRuleGuid(), exceptionList);
        }
    }

    public InvalidRulesException(String msg) {
        super(msg);
    }

    public InvalidRulesException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public void add(InvalidRuleException exception) {
        List<InvalidRuleException> exceptions = this._exceptionsMap.get(exception.getRuleGuid());
        if (exceptions == null) {
            exceptions = new ArrayList<InvalidRuleException>();
        }
        exceptions.add(exception);
        this._exceptionsMap.put(exception.getRuleGuid(), exceptions);
    }

    public List<InvalidRuleException> getRuleExceptions(String ruleId) {
        return this._exceptionsMap.get(ruleId);
    }
}

