/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.exception;

import com.liferay.content.targeting.exception.InvalidChannelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvalidChannelsException
extends PortalException {
    private final Map<String, List<InvalidChannelException>> _exceptionsMap = new HashMap<String, List<InvalidChannelException>>();

    public InvalidChannelsException() {
    }

    public InvalidChannelsException(List<InvalidChannelException> exceptions) {
        if (Validator.isNull(exceptions)) {
            return;
        }
        for (InvalidChannelException exception : exceptions) {
            String guid = exception.getChannelGuid();
            List<InvalidChannelException> exceptionList = new ArrayList<InvalidChannelException>();
            if (this._exceptionsMap.containsKey(guid)) {
                exceptionList = this._exceptionsMap.get(guid);
            }
            exceptionList.add(exception);
            this._exceptionsMap.put(exception.getChannelGuid(), exceptionList);
        }
    }

    public InvalidChannelsException(String msg) {
        super(msg);
    }

    public InvalidChannelsException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public void add(InvalidChannelException exception) {
        List<InvalidChannelException> exceptions = this._exceptionsMap.get(exception.getChannelGuid());
        if (exceptions == null) {
            exceptions = new ArrayList<InvalidChannelException>();
        }
        exceptions.add(exception);
        this._exceptionsMap.put(exception.getChannelGuid(), exceptions);
    }

    public List<InvalidChannelException> getExceptions(String channelId) {
        return this._exceptionsMap.get(channelId);
    }
}

