/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.api.model;

import com.liferay.content.targeting.api.model.TrackingAction;
import com.liferay.content.targeting.exception.InvalidTrackingActionException;
import com.liferay.content.targeting.model.Campaign;
import com.liferay.content.targeting.model.TrackingActionInstance;
import com.liferay.content.targeting.util.ContentTargetingUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Element;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public abstract class BaseTrackingAction
implements TrackingAction {
    private static final Log _log = LogFactoryUtil.getLog(BaseTrackingAction.class);

    @Override
    public void activate() {
        if (_log.isDebugEnabled()) {
            Class<?> clazz = this.getClass();
            _log.debug((Object)("Tracking Action activate: " + clazz.getSimpleName()));
        }
    }

    @Override
    public void deActivate() {
        if (_log.isDebugEnabled()) {
            Class<?> clazz = this.getClass();
            _log.debug((Object)("Tracking Action deactivate: " + clazz.getSimpleName()));
        }
    }

    @Override
    public void deleteData(TrackingActionInstance trackingActionInstance) throws PortalException {
    }

    @Override
    public void exportData(PortletDataContext portletDataContext, Element campaignElement, Campaign campaign, Element trackingInstanceElement, TrackingActionInstance trackingActionInstance) throws Exception {
    }

    @Override
    public String getDescription(Locale locale) {
        return ContentTargetingUtil.getDescription(this.getClass(), locale);
    }

    @Override
    public String getIcon() {
        return "icon-file";
    }

    @Override
    public String getName(Locale locale) {
        return ContentTargetingUtil.getName(this.getClass(), locale);
    }

    @Override
    public String getShortDescription(Locale locale) {
        return ContentTargetingUtil.getShortDescription(this.getClass(), locale);
    }

    @Override
    public String getTrackingActionKey() {
        Class<?> clazz = this.getClass();
        return clazz.getSimpleName();
    }

    @Override
    public void importData(PortletDataContext portletDataContext, Campaign campaign, TrackingActionInstance trackingActionInstance) throws Exception {
    }

    @Override
    public boolean isInstantiable() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isVisible(String className, long classPK) {
        return true;
    }

    @Override
    public String processTrackingAction(PortletRequest portletRequest, PortletResponse portletResponse, String id, Map<String, String> values) throws InvalidTrackingActionException {
        return null;
    }

    protected String getExportImportErrorMessage(Campaign campaign, TrackingActionInstance trackingActionInstance, String missingReferenceClassName, String missingReferenceId, String action) {
        StringBundler sb = new StringBundler(9);
        if (action.equals("export")) {
            sb.append("Cannot export tracking action ");
        } else {
            sb.append("Cannot import tracking action ");
        }
        sb.append(this.getName(LocaleUtil.getDefault()));
        sb.append(" from campaign ");
        sb.append(campaign.getName(LocaleUtil.getDefault()));
        sb.append(" because it refers to a missing ");
        sb.append(ResourceActionsUtil.getModelResource((Locale)LocaleUtil.getDefault(), (String)missingReferenceClassName));
        sb.append(" with id ");
        sb.append(missingReferenceId);
        sb.append(".");
        return sb.toString();
    }
}

