/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.api.model;

import com.liferay.content.targeting.api.model.Channel;
import com.liferay.content.targeting.exception.InvalidChannelException;
import com.liferay.content.targeting.model.ChannelInstance;
import com.liferay.content.targeting.model.Tactic;
import com.liferay.content.targeting.util.ContentTargetingUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Element;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public abstract class BaseChannel
implements Channel {
    private static final Log _log = LogFactoryUtil.getLog(BaseChannel.class);

    @Override
    public void activate() {
        if (_log.isDebugEnabled()) {
            Class<?> clazz = this.getClass();
            _log.debug((Object)("Channel activate: " + clazz.getSimpleName()));
        }
    }

    @Override
    public void deActivate() {
        if (_log.isDebugEnabled()) {
            Class<?> clazz = this.getClass();
            _log.debug((Object)("Channel deactivate: " + clazz.getSimpleName()));
        }
    }

    @Override
    public void deleteData(ChannelInstance channelInstance) throws PortalException {
    }

    @Override
    public void exportData(PortletDataContext portletDataContext, Element tacticElement, Tactic tactic, Element channelInstanceElement, ChannelInstance channelInstance) throws Exception {
    }

    @Override
    public String getChannelKey() {
        Class<?> clazz = this.getClass();
        return clazz.getSimpleName();
    }

    @Override
    public String getDescription(Locale locale) {
        return ContentTargetingUtil.getDescription(this.getClass(), locale);
    }

    @Override
    public String getIcon() {
        return "icon-file";
    }

    @Override
    public String getName(Locale locale) {
        return ContentTargetingUtil.getName(this.getClass(), locale);
    }

    @Override
    public String getShortDescription(Locale locale) {
        return ContentTargetingUtil.getShortDescription(this.getClass(), locale);
    }

    @Override
    public void importData(PortletDataContext portletDataContext, Tactic tactic, ChannelInstance channelInstance) throws Exception {
    }

    @Override
    public boolean isInstantiable() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public String processChannel(PortletRequest portletRequest, PortletResponse portletResponse, String id, Map<String, String> values) throws InvalidChannelException {
        return "";
    }

    @Override
    public void updateChannel(String typeSettings, long channelInstanceId) {
    }

    protected String getExportImportErrorMessage(Tactic tactic, ChannelInstance channelInstance, String missingReferenceClassName, String missingReferenceId, String action) {
        StringBundler sb = new StringBundler(9);
        if (action.equals("export")) {
            sb.append("Cannot export channel ");
        } else {
            sb.append("Cannot import channel ");
        }
        sb.append(this.getName(LocaleUtil.getDefault()));
        sb.append(" from tactic ");
        sb.append(tactic.getName(LocaleUtil.getDefault()));
        sb.append(" because it refers to a missing ");
        sb.append(ResourceActionsUtil.getModelResource((Locale)LocaleUtil.getDefault(), (String)missingReferenceClassName));
        sb.append(" with id ");
        sb.append(missingReferenceId);
        sb.append(".");
        return sb.toString();
    }
}

