/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.content.targeting.service.permission;

import aQute.bnd.annotation.ProviderType;

import com.liferay.content.targeting.model.Tactic;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

/**
 * @author Pavel Savinov
 */
@ProviderType
public interface TacticPermission {

	public void check(
			PermissionChecker permissionChecker, long tacticId, String actionId)
		throws PortalException;

	public void check(
			PermissionChecker permissionChecker, Tactic tactic, String actionId)
		throws PortalException;

	public boolean contains(
		PermissionChecker permissionChecker, long groupId, long tacticId,
		String actionId);

	public boolean contains(
			PermissionChecker permissionChecker, long tacticId, String actionId)
		throws PortalException;

	public boolean contains(
		PermissionChecker permissionChecker, Tactic tactic, String actionId);

}