/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.content.targeting.service;

import aQute.bnd.annotation.ProviderType;

import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import org.osgi.util.tracker.ServiceTracker;

/**
 * Provides the remote service utility for Tactic. This utility wraps
 * {@link com.liferay.content.targeting.service.impl.TacticServiceImpl} and is the
 * primary access point for service operations in application layer code running
 * on a remote server. Methods of this service are expected to have security
 * checks based on the propagated JAAS credentials because this service can be
 * accessed remotely.
 *
 * @author Brian Wing Shun Chan
 * @see TacticService
 * @see com.liferay.content.targeting.service.base.TacticServiceBaseImpl
 * @see com.liferay.content.targeting.service.impl.TacticServiceImpl
 * @generated
 */
@ProviderType
public class TacticServiceUtil {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Add custom service methods to {@link com.liferay.content.targeting.service.impl.TacticServiceImpl} and rerun ServiceBuilder to regenerate this class.
	 */
	public static com.liferay.content.targeting.model.Tactic addTactic(
		long userId, long campaignId,
		java.util.Map<java.util.Locale, String> nameMap,
		java.util.Map<java.util.Locale, String> descriptionMap,
		long[] userSegmentsIds,
		com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {
		return getService()
				   .addTactic(userId, campaignId, nameMap, descriptionMap,
			userSegmentsIds, serviceContext);
	}

	/**
	* Returns the OSGi service identifier.
	*
	* @return the OSGi service identifier
	*/
	public static String getOSGiServiceIdentifier() {
		return getService().getOSGiServiceIdentifier();
	}

	public static java.util.List<com.liferay.content.targeting.model.Tactic> getTactics(
		long campaignId) {
		return getService().getTactics(campaignId);
	}

	public static com.liferay.content.targeting.model.Tactic updateTactic(
		long tacticId, long campaignId,
		java.util.Map<java.util.Locale, String> nameMap,
		java.util.Map<java.util.Locale, String> descriptionMap,
		long[] userSegmentsIds,
		com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {
		return getService()
				   .updateTactic(tacticId, campaignId, nameMap, descriptionMap,
			userSegmentsIds, serviceContext);
	}

	public static TacticService getService() {
		return _serviceTracker.getService();
	}

	private static ServiceTracker<TacticService, TacticService> _serviceTracker;

	static {
		Bundle bundle = FrameworkUtil.getBundle(TacticService.class);

		ServiceTracker<TacticService, TacticService> serviceTracker = new ServiceTracker<TacticService, TacticService>(bundle.getBundleContext(),
				TacticService.class, null);

		serviceTracker.open();

		_serviceTracker = serviceTracker;
	}
}