/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.content.targeting.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

/**
 * The base model interface for the Tactic service. Represents a row in the &quot;CT_Tactic&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.content.targeting.model.impl.TacticModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.content.targeting.model.impl.TacticImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see Tactic
 * @see com.liferay.content.targeting.model.impl.TacticImpl
 * @see com.liferay.content.targeting.model.impl.TacticModelImpl
 * @generated
 */
@ProviderType
public interface TacticModel extends BaseModel<Tactic>, GroupedModel,
	LocalizedModel, ShardedModel, StagedAuditedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a tactic model instance should use the {@link Tactic} interface instead.
	 */

	/**
	 * Returns the primary key of this tactic.
	 *
	 * @return the primary key of this tactic
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this tactic.
	 *
	 * @param primaryKey the primary key of this tactic
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this tactic.
	 *
	 * @return the uuid of this tactic
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this tactic.
	 *
	 * @param uuid the uuid of this tactic
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the tactic ID of this tactic.
	 *
	 * @return the tactic ID of this tactic
	 */
	public long getTacticId();

	/**
	 * Sets the tactic ID of this tactic.
	 *
	 * @param tacticId the tactic ID of this tactic
	 */
	public void setTacticId(long tacticId);

	/**
	 * Returns the group ID of this tactic.
	 *
	 * @return the group ID of this tactic
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this tactic.
	 *
	 * @param groupId the group ID of this tactic
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this tactic.
	 *
	 * @return the company ID of this tactic
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this tactic.
	 *
	 * @param companyId the company ID of this tactic
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this tactic.
	 *
	 * @return the user ID of this tactic
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this tactic.
	 *
	 * @param userId the user ID of this tactic
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this tactic.
	 *
	 * @return the user uuid of this tactic
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this tactic.
	 *
	 * @param userUuid the user uuid of this tactic
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this tactic.
	 *
	 * @return the user name of this tactic
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this tactic.
	 *
	 * @param userName the user name of this tactic
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this tactic.
	 *
	 * @return the create date of this tactic
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this tactic.
	 *
	 * @param createDate the create date of this tactic
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this tactic.
	 *
	 * @return the modified date of this tactic
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this tactic.
	 *
	 * @param modifiedDate the modified date of this tactic
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the campaign ID of this tactic.
	 *
	 * @return the campaign ID of this tactic
	 */
	public long getCampaignId();

	/**
	 * Sets the campaign ID of this tactic.
	 *
	 * @param campaignId the campaign ID of this tactic
	 */
	public void setCampaignId(long campaignId);

	/**
	 * Returns the name of this tactic.
	 *
	 * @return the name of this tactic
	 */
	public String getName();

	/**
	 * Returns the localized name of this tactic in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this tactic
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this tactic in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this tactic. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this tactic in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this tactic
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this tactic in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this tactic
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this tactic.
	 *
	 * @return the locales and localized names of this tactic
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this tactic.
	 *
	 * @param name the name of this tactic
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this tactic in the language.
	 *
	 * @param name the localized name of this tactic
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this tactic in the language, and sets the default locale.
	 *
	 * @param name the localized name of this tactic
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this tactic from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this tactic
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this tactic from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this tactic
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	/**
	 * Returns the description of this tactic.
	 *
	 * @return the description of this tactic
	 */
	public String getDescription();

	/**
	 * Returns the localized description of this tactic in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized description of this tactic
	 */
	@AutoEscape
	public String getDescription(Locale locale);

	/**
	 * Returns the localized description of this tactic in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized description of this tactic. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getDescription(Locale locale, boolean useDefault);

	/**
	 * Returns the localized description of this tactic in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized description of this tactic
	 */
	@AutoEscape
	public String getDescription(String languageId);

	/**
	 * Returns the localized description of this tactic in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized description of this tactic
	 */
	@AutoEscape
	public String getDescription(String languageId, boolean useDefault);

	@AutoEscape
	public String getDescriptionCurrentLanguageId();

	@AutoEscape
	public String getDescriptionCurrentValue();

	/**
	 * Returns a map of the locales and localized descriptions of this tactic.
	 *
	 * @return the locales and localized descriptions of this tactic
	 */
	public Map<Locale, String> getDescriptionMap();

	/**
	 * Sets the description of this tactic.
	 *
	 * @param description the description of this tactic
	 */
	public void setDescription(String description);

	/**
	 * Sets the localized description of this tactic in the language.
	 *
	 * @param description the localized description of this tactic
	 * @param locale the locale of the language
	 */
	public void setDescription(String description, Locale locale);

	/**
	 * Sets the localized description of this tactic in the language, and sets the default locale.
	 *
	 * @param description the localized description of this tactic
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setDescription(String description, Locale locale,
		Locale defaultLocale);

	public void setDescriptionCurrentLanguageId(String languageId);

	/**
	 * Sets the localized descriptions of this tactic from the map of locales and localized descriptions.
	 *
	 * @param descriptionMap the locales and localized descriptions of this tactic
	 */
	public void setDescriptionMap(Map<Locale, String> descriptionMap);

	/**
	 * Sets the localized descriptions of this tactic from the map of locales and localized descriptions, and sets the default locale.
	 *
	 * @param descriptionMap the locales and localized descriptions of this tactic
	 * @param defaultLocale the default locale
	 */
	public void setDescriptionMap(Map<Locale, String> descriptionMap,
		Locale defaultLocale);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public Object clone();

	@Override
	public int compareTo(Tactic tactic);

	@Override
	public int hashCode();

	@Override
	public CacheModel<Tactic> toCacheModel();

	@Override
	public Tactic toEscapedModel();

	@Override
	public Tactic toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}