/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.content.targeting.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the AnonymousUserUserSegment service. Represents a row in the &quot;CT_AnonymousUserUserSegment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.content.targeting.model.impl.AnonymousUserUserSegmentModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.content.targeting.model.impl.AnonymousUserUserSegmentImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AnonymousUserUserSegment
 * @see com.liferay.content.targeting.model.impl.AnonymousUserUserSegmentImpl
 * @see com.liferay.content.targeting.model.impl.AnonymousUserUserSegmentModelImpl
 * @generated
 */
@ProviderType
public interface AnonymousUserUserSegmentModel extends BaseModel<AnonymousUserUserSegment>,
	ShardedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a anonymous user user segment model instance should use the {@link AnonymousUserUserSegment} interface instead.
	 */

	/**
	 * Returns the primary key of this anonymous user user segment.
	 *
	 * @return the primary key of this anonymous user user segment
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this anonymous user user segment.
	 *
	 * @param primaryKey the primary key of this anonymous user user segment
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the anonymous user user segment ID of this anonymous user user segment.
	 *
	 * @return the anonymous user user segment ID of this anonymous user user segment
	 */
	public long getAnonymousUserUserSegmentId();

	/**
	 * Sets the anonymous user user segment ID of this anonymous user user segment.
	 *
	 * @param anonymousUserUserSegmentId the anonymous user user segment ID of this anonymous user user segment
	 */
	public void setAnonymousUserUserSegmentId(long anonymousUserUserSegmentId);

	/**
	 * Returns the company ID of this anonymous user user segment.
	 *
	 * @return the company ID of this anonymous user user segment
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this anonymous user user segment.
	 *
	 * @param companyId the company ID of this anonymous user user segment
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the modified date of this anonymous user user segment.
	 *
	 * @return the modified date of this anonymous user user segment
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this anonymous user user segment.
	 *
	 * @param modifiedDate the modified date of this anonymous user user segment
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the anonymous user ID of this anonymous user user segment.
	 *
	 * @return the anonymous user ID of this anonymous user user segment
	 */
	public long getAnonymousUserId();

	/**
	 * Sets the anonymous user ID of this anonymous user user segment.
	 *
	 * @param anonymousUserId the anonymous user ID of this anonymous user user segment
	 */
	public void setAnonymousUserId(long anonymousUserId);

	/**
	 * Returns the anonymous user uuid of this anonymous user user segment.
	 *
	 * @return the anonymous user uuid of this anonymous user user segment
	 */
	public String getAnonymousUserUuid();

	/**
	 * Sets the anonymous user uuid of this anonymous user user segment.
	 *
	 * @param anonymousUserUuid the anonymous user uuid of this anonymous user user segment
	 */
	public void setAnonymousUserUuid(String anonymousUserUuid);

	/**
	 * Returns the user segment ID of this anonymous user user segment.
	 *
	 * @return the user segment ID of this anonymous user user segment
	 */
	public long getUserSegmentId();

	/**
	 * Sets the user segment ID of this anonymous user user segment.
	 *
	 * @param userSegmentId the user segment ID of this anonymous user user segment
	 */
	public void setUserSegmentId(long userSegmentId);

	/**
	 * Returns the manual of this anonymous user user segment.
	 *
	 * @return the manual of this anonymous user user segment
	 */
	public boolean getManual();

	/**
	 * Returns <code>true</code> if this anonymous user user segment is manual.
	 *
	 * @return <code>true</code> if this anonymous user user segment is manual; <code>false</code> otherwise
	 */
	public boolean isManual();

	/**
	 * Sets whether this anonymous user user segment is manual.
	 *
	 * @param manual the manual of this anonymous user user segment
	 */
	public void setManual(boolean manual);

	/**
	 * Returns the active of this anonymous user user segment.
	 *
	 * @return the active of this anonymous user user segment
	 */
	public boolean getActive();

	/**
	 * Returns <code>true</code> if this anonymous user user segment is active.
	 *
	 * @return <code>true</code> if this anonymous user user segment is active; <code>false</code> otherwise
	 */
	public boolean isActive();

	/**
	 * Sets whether this anonymous user user segment is active.
	 *
	 * @param active the active of this anonymous user user segment
	 */
	public void setActive(boolean active);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(AnonymousUserUserSegment anonymousUserUserSegment);

	@Override
	public int hashCode();

	@Override
	public CacheModel<AnonymousUserUserSegment> toCacheModel();

	@Override
	public AnonymousUserUserSegment toEscapedModel();

	@Override
	public AnonymousUserUserSegment toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}