/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.service.CPDefinitionLinkLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.RelatedProductDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseRelatedProductResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.RelatedProductResource;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/related-product.properties"}, scope=ServiceScope.PROTOTYPE, service={RelatedProductResource.class})
public class RelatedProductResourceImpl
extends BaseRelatedProductResourceImpl {
    @Reference
    private CPDefinitionLinkLocalService _cpDefinitionLinkLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private RelatedProductDTOConverter _relatedProductDTOConverter;

    @Override
    @NestedField(parentClass=Product.class, value="relatedProducts")
    public Page<RelatedProduct> getChannelProductRelatedProductsPage(@NotNull Long channelId, @NestedFieldId(value="productId") @NotNull Long productId, String type, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        return this._getRelatedProductPage(cpDefinition, type, pagination);
    }

    private Page<RelatedProduct> _getRelatedProductPage(CPDefinition cpDefinition, String type, Pagination pagination) throws Exception {
        int totalItems;
        List cpDefinitionLinks;
        if (Validator.isNull((String)type)) {
            cpDefinitionLinks = this._cpDefinitionLinkLocalService.getCPDefinitionLinks(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
            totalItems = this._cpDefinitionLinkLocalService.getCPDefinitionLinksCount(cpDefinition.getCPDefinitionId());
        } else {
            cpDefinitionLinks = this._cpDefinitionLinkLocalService.getCPDefinitionLinks(cpDefinition.getCPDefinitionId(), type, pagination.getStartPosition(), pagination.getEndPosition(), null);
            totalItems = this._cpDefinitionLinkLocalService.getCPDefinitionLinksCount(cpDefinition.getCPDefinitionId(), type);
        }
        return Page.of(this._toRelatedProducts(cpDefinitionLinks), (Pagination)pagination, (long)totalItems);
    }

    private List<RelatedProduct> _toRelatedProducts(List<CPDefinitionLink> cpDefinitionLinks) throws Exception {
        ArrayList<RelatedProduct> relatedProducts = new ArrayList<RelatedProduct>();
        for (CPDefinitionLink cpDefinitionLink : cpDefinitionLinks) {
            relatedProducts.add(this._relatedProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionLink.getCPDefinitionLinkId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return relatedProducts;
    }
}

