/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.ProductSpecificationDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseProductSpecificationResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.ProductSpecificationResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/product-specification.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductSpecificationResource.class})
public class ProductSpecificationResourceImpl
extends BaseProductSpecificationResourceImpl {
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionSpecificationOptionValueLocalService _cpDefinitionSpecificationOptionValueLocalService;
    @Reference
    private ProductSpecificationDTOConverter _productSpecificationDTOConverter;

    @Override
    @NestedField(parentClass=Product.class, value="productSpecifications")
    public Page<ProductSpecification> getChannelProductProductSpecificationsPage(@NotNull Long channelId, @NestedFieldId(value="productId") @NotNull Long productId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        List cpDefinitionSpecificationOptionValues = this._cpDefinitionSpecificationOptionValueLocalService.getCPDefinitionSpecificationOptionValues(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._cpDefinitionSpecificationOptionValueLocalService.getCPDefinitionSpecificationOptionValuesCount(cpDefinition.getCPDefinitionId());
        return Page.of(this._toProductSpecifications(cpDefinitionSpecificationOptionValues), (Pagination)pagination, (long)totalItems);
    }

    private List<ProductSpecification> _toProductSpecifications(List<CPDefinitionSpecificationOptionValue> cpDefinitionSpecificationOptionValues) throws Exception {
        ArrayList<ProductSpecification> productSpecifications = new ArrayList<ProductSpecification>();
        for (CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            productSpecifications.add(this._productSpecificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return productSpecifications;
    }
}

