/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.exception.NoSuchCProductException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.ProductDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.ProductDTOConverterContext;
import com.liferay.headless.commerce.delivery.catalog.internal.odata.entity.v1_0.ProductEntityModel;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseProductResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.ProductResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/product.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductResource.class})
public class ProductResourceImpl
extends BaseProductResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new ProductEntityModel();
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private ProductDTOConverter _productDTOConverter;

    @Override
    public Product getChannelProduct(@NotNull Long channelId, @NotNull Long productId, Long accountId) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCProductException();
        }
        this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), this._getAccountId(accountId, commerceChannel).longValue(), commerceChannel.getGroupId(), cpDefinition.getCPDefinitionId());
        return this._toProduct(cpDefinition);
    }

    @Override
    public Page<Product> getChannelProductsPage(@NotNull Long channelId, Long accountId, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        long companyId = this.contextCompany.getCompanyId();
        SearchContext searchContext = new SearchContext();
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        HashMap attributes = HashMapBuilder.put((Object)"status", (Object)0).put((Object)"commerceChannelGroupId", (Object)commerceChannel.getGroupId()).build();
        long[] commerceAccountGroupIds = this._commerceAccountHelper.getCommerceAccountGroupIds(this._getAccountId(accountId, commerceChannel).longValue());
        searchContext.setAttribute("commerceAccountGroupIds", (Serializable)commerceAccountGroupIds);
        searchContext.setAttributes((Map)attributes);
        searchContext.setCompanyId(companyId);
        CPQuery cpQuery = new CPQuery();
        cpQuery.setOrderByCol1("title");
        cpQuery.setOrderByCol2("modifiedDate");
        cpQuery.setOrderByType1("ASC");
        cpQuery.setOrderByType2("DESC");
        BooleanClause<Query> booleanClause = this._getBooleanClause((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> booleanQuery.getPreBooleanFilter()), filter);
        searchContext.setBooleanClauses(new BooleanClause[]{booleanClause});
        CPDataSourceResult cpDataSourceResult = this._cpDefinitionHelper.search(commerceChannel.getGroupId(), searchContext, cpQuery, pagination.getStartPosition(), pagination.getEndPosition());
        return Page.of(this._toProducts(cpDataSourceResult), (Pagination)pagination, (long)cpDataSourceResult.getLength());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    private Long _getAccountId(Long accountId, CommerceChannel commerceChannel) throws Exception {
        int countUserCommerceAccounts = this._commerceAccountHelper.countUserCommerceAccounts(this.contextUser.getUserId(), commerceChannel.getGroupId());
        if (countUserCommerceAccounts > 1) {
            if (accountId == null) {
                throw new NoSuchAccountException();
            }
        } else {
            long[] commerceAccountIds = this._commerceAccountHelper.getUserCommerceAccountIds(this.contextUser.getUserId(), commerceChannel.getGroupId());
            return commerceAccountIds[0];
        }
        return accountId;
    }

    private BooleanClause<Query> _getBooleanClause(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, final Filter filter) throws Exception {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl(){
            {
                this.add((Query)new MatchAllQuery(), BooleanClauseOccur.MUST);
                BooleanFilter booleanFilter = new BooleanFilter();
                if (filter != null) {
                    booleanFilter.add(filter, BooleanClauseOccur.MUST);
                }
                this.setPreBooleanFilter(booleanFilter);
            }
        };
        booleanQueryUnsafeConsumer.accept((Object)booleanQuery);
        return BooleanClauseFactoryUtil.create((Query)booleanQuery, (String)BooleanClauseOccur.MUST.getName());
    }

    private Product _toProduct(CPDefinition cpDefinition) throws Exception {
        return this._productDTOConverter.toDTO((DTOConverterContext)new ProductDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId(), cpDefinition));
    }

    private List<Product> _toProducts(CPDataSourceResult cpDataSourceResult) throws Exception {
        ArrayList<Product> products = new ArrayList<Product>();
        for (CPCatalogEntry cpCatalogEntry : cpDataSourceResult.getCPCatalogEntries()) {
            products.add(this._productDTOConverter.toDTO((DTOConverterContext)new ProductDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpCatalogEntry.getCPDefinitionId(), cpCatalogEntry)));
        }
        return products;
    }
}

