/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.ProductOptionDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseProductOptionResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.ProductOptionResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/product-option.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductOptionResource.class})
public class ProductOptionResourceImpl
extends BaseProductOptionResourceImpl {
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private ProductOptionDTOConverter _productOptionDTOConverter;

    @Override
    @NestedField(parentClass=Product.class, value="productOptions")
    public Page<ProductOption> getChannelProductOptionsPage(@NotNull Long channelId, @NestedFieldId(value="productId") @NotNull Long productId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        List cpDefinitionOptionRels = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelsCount(cpDefinition.getCPDefinitionId());
        return Page.of(this._toProductOptions(cpDefinitionOptionRels), (Pagination)pagination, (long)totalItems);
    }

    private List<ProductOption> _toProductOptions(List<CPDefinitionOptionRel> cpDefinitionOptionRels) throws Exception {
        ArrayList<ProductOption> productOptions = new ArrayList<ProductOption>();
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            productOptions.add(this._productOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionOptionRel.getCPDefinitionOptionRelId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return productOptions;
    }
}

