/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.AttachmentDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseAttachmentResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.AttachmentResource;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={AttachmentResource.class})
public class AttachmentResourceImpl
extends BaseAttachmentResourceImpl {
    @Reference
    private AttachmentDTOConverter _attachmentDTOConverter;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;

    @Override
    @NestedField(parentClass=Product.class, value="attachments")
    public Page<Attachment> getChannelProductAttachmentsPage(@NotNull Long channelId, @NestedFieldId(value="productId") @NotNull Long productId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        return this._getAttachmentPage(cpDefinition, 1, pagination);
    }

    @Override
    @NestedField(parentClass=Product.class, value="images")
    public Page<Attachment> getChannelProductImagesPage(@NotNull Long channelId, @NestedFieldId(value="productId") @NotNull Long productId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        return this._getAttachmentPage(cpDefinition, 0, pagination);
    }

    private Page<Attachment> _getAttachmentPage(CPDefinition cpDefinition, int type, Pagination pagination) throws Exception {
        List cpAttachmentFileEntries = this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntries(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), type, 0, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), type, 0);
        return Page.of(this._toAttachments(cpAttachmentFileEntries), (Pagination)pagination, (long)totalItems);
    }

    private List<Attachment> _toAttachments(List<CPAttachmentFileEntry> cpAttachmentFileEntries) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (CPAttachmentFileEntry cpAttachmentFileEntry : cpAttachmentFileEntries) {
            attachments.add(this._attachmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpAttachmentFileEntry.getCPAttachmentFileEntryId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return attachments;
    }
}

