/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.graphql.query.v1_0;

import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.AttachmentResource;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.CategoryResource;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.ProductOptionResource;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.ProductResource;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.ProductSpecificationResource;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.RelatedProductResource;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.SkuResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<AttachmentResource> _attachmentResourceComponentServiceObjects;
    private static ComponentServiceObjects<CategoryResource> _categoryResourceComponentServiceObjects;
    private static ComponentServiceObjects<ProductResource> _productResourceComponentServiceObjects;
    private static ComponentServiceObjects<ProductOptionResource> _productOptionResourceComponentServiceObjects;
    private static ComponentServiceObjects<ProductSpecificationResource> _productSpecificationResourceComponentServiceObjects;
    private static ComponentServiceObjects<RelatedProductResource> _relatedProductResourceComponentServiceObjects;
    private static ComponentServiceObjects<SkuResource> _skuResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setAttachmentResourceComponentServiceObjects(ComponentServiceObjects<AttachmentResource> attachmentResourceComponentServiceObjects) {
        _attachmentResourceComponentServiceObjects = attachmentResourceComponentServiceObjects;
    }

    public static void setCategoryResourceComponentServiceObjects(ComponentServiceObjects<CategoryResource> categoryResourceComponentServiceObjects) {
        _categoryResourceComponentServiceObjects = categoryResourceComponentServiceObjects;
    }

    public static void setProductResourceComponentServiceObjects(ComponentServiceObjects<ProductResource> productResourceComponentServiceObjects) {
        _productResourceComponentServiceObjects = productResourceComponentServiceObjects;
    }

    public static void setProductOptionResourceComponentServiceObjects(ComponentServiceObjects<ProductOptionResource> productOptionResourceComponentServiceObjects) {
        _productOptionResourceComponentServiceObjects = productOptionResourceComponentServiceObjects;
    }

    public static void setProductSpecificationResourceComponentServiceObjects(ComponentServiceObjects<ProductSpecificationResource> productSpecificationResourceComponentServiceObjects) {
        _productSpecificationResourceComponentServiceObjects = productSpecificationResourceComponentServiceObjects;
    }

    public static void setRelatedProductResourceComponentServiceObjects(ComponentServiceObjects<RelatedProductResource> relatedProductResourceComponentServiceObjects) {
        _relatedProductResourceComponentServiceObjects = relatedProductResourceComponentServiceObjects;
    }

    public static void setSkuResourceComponentServiceObjects(ComponentServiceObjects<SkuResource> skuResourceComponentServiceObjects) {
        _skuResourceComponentServiceObjects = skuResourceComponentServiceObjects;
    }

    @GraphQLField
    public AttachmentPage channelProductAttachments(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="productId") Long productId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (AttachmentPage)this._applyComponentServiceObjects(_attachmentResourceComponentServiceObjects, this::_populateResourceContext, attachmentResource -> new AttachmentPage(attachmentResource.getChannelProductAttachmentsPage(channelId, productId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public AttachmentPage channelProductImages(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="productId") Long productId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (AttachmentPage)this._applyComponentServiceObjects(_attachmentResourceComponentServiceObjects, this::_populateResourceContext, attachmentResource -> new AttachmentPage(attachmentResource.getChannelProductImagesPage(channelId, productId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Gets a list of Category related to a Product.")
    public @GraphQLField(description="Gets a list of Category related to a Product.") CategoryPage channelProductCategories(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="productId") Long productId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (CategoryPage)this._applyComponentServiceObjects(_categoryResourceComponentServiceObjects, this::_populateResourceContext, categoryResource -> new CategoryPage(categoryResource.getChannelProductCategoriesPage(channelId, productId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrieves products from selected channel.")
    public @GraphQLField(description="Retrieves products from selected channel.") ProductPage channelProducts(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="accountId") Long accountId, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (ProductPage)this._applyComponentServiceObjects(_productResourceComponentServiceObjects, this::_populateResourceContext, productResource -> new ProductPage(productResource.getChannelProductsPage(channelId, accountId, this._filterBiFunction.apply(productResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(productResource, sortsString))));
    }

    @GraphQLField(description="Retrieves products from selected channel.")
    public @GraphQLField(description="Retrieves products from selected channel.") Product channelProduct(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="productId") Long productId, @GraphQLName(value="accountId") Long accountId) throws Exception {
        return (Product)this._applyComponentServiceObjects(_productResourceComponentServiceObjects, this::_populateResourceContext, productResource -> productResource.getChannelProduct(channelId, productId, accountId));
    }

    @GraphQLField
    public ProductOptionPage channelProductOptions(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="productId") Long productId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (ProductOptionPage)this._applyComponentServiceObjects(_productOptionResourceComponentServiceObjects, this::_populateResourceContext, productOptionResource -> new ProductOptionPage(productOptionResource.getChannelProductOptionsPage(channelId, productId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField
    public ProductSpecificationPage channelProductProductSpecifications(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="productId") Long productId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (ProductSpecificationPage)this._applyComponentServiceObjects(_productSpecificationResourceComponentServiceObjects, this::_populateResourceContext, productSpecificationResource -> new ProductSpecificationPage(productSpecificationResource.getChannelProductProductSpecificationsPage(channelId, productId, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Gets a list of Related Products of a Product.")
    public @GraphQLField(description="Gets a list of Related Products of a Product.") RelatedProductPage channelProductRelatedProducts(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="productId") Long productId, @GraphQLName(value="type") String type, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (RelatedProductPage)this._applyComponentServiceObjects(_relatedProductResourceComponentServiceObjects, this::_populateResourceContext, relatedProductResource -> new RelatedProductPage(relatedProductResource.getChannelProductRelatedProductsPage(channelId, productId, type, Pagination.of((int)page, (int)pageSize))));
    }

    @GraphQLField(description="Retrieves products from selected channel.")
    public @GraphQLField(description="Retrieves products from selected channel.") SkuPage channelProductSkus(@GraphQLName(value="channelId") Long channelId, @GraphQLName(value="productId") Long productId, @GraphQLName(value="accountId") Long accountId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (SkuPage)this._applyComponentServiceObjects(_skuResourceComponentServiceObjects, this::_populateResourceContext, skuResource -> new SkuPage(skuResource.getChannelProductSkusPage(channelId, productId, accountId, Pagination.of((int)page, (int)pageSize))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(AttachmentResource attachmentResource) throws Exception {
        attachmentResource.setContextAcceptLanguage(this._acceptLanguage);
        attachmentResource.setContextCompany(this._company);
        attachmentResource.setContextHttpServletRequest(this._httpServletRequest);
        attachmentResource.setContextHttpServletResponse(this._httpServletResponse);
        attachmentResource.setContextUriInfo(this._uriInfo);
        attachmentResource.setContextUser(this._user);
        attachmentResource.setGroupLocalService(this._groupLocalService);
        attachmentResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(CategoryResource categoryResource) throws Exception {
        categoryResource.setContextAcceptLanguage(this._acceptLanguage);
        categoryResource.setContextCompany(this._company);
        categoryResource.setContextHttpServletRequest(this._httpServletRequest);
        categoryResource.setContextHttpServletResponse(this._httpServletResponse);
        categoryResource.setContextUriInfo(this._uriInfo);
        categoryResource.setContextUser(this._user);
        categoryResource.setGroupLocalService(this._groupLocalService);
        categoryResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(ProductResource productResource) throws Exception {
        productResource.setContextAcceptLanguage(this._acceptLanguage);
        productResource.setContextCompany(this._company);
        productResource.setContextHttpServletRequest(this._httpServletRequest);
        productResource.setContextHttpServletResponse(this._httpServletResponse);
        productResource.setContextUriInfo(this._uriInfo);
        productResource.setContextUser(this._user);
        productResource.setGroupLocalService(this._groupLocalService);
        productResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(ProductOptionResource productOptionResource) throws Exception {
        productOptionResource.setContextAcceptLanguage(this._acceptLanguage);
        productOptionResource.setContextCompany(this._company);
        productOptionResource.setContextHttpServletRequest(this._httpServletRequest);
        productOptionResource.setContextHttpServletResponse(this._httpServletResponse);
        productOptionResource.setContextUriInfo(this._uriInfo);
        productOptionResource.setContextUser(this._user);
        productOptionResource.setGroupLocalService(this._groupLocalService);
        productOptionResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(ProductSpecificationResource productSpecificationResource) throws Exception {
        productSpecificationResource.setContextAcceptLanguage(this._acceptLanguage);
        productSpecificationResource.setContextCompany(this._company);
        productSpecificationResource.setContextHttpServletRequest(this._httpServletRequest);
        productSpecificationResource.setContextHttpServletResponse(this._httpServletResponse);
        productSpecificationResource.setContextUriInfo(this._uriInfo);
        productSpecificationResource.setContextUser(this._user);
        productSpecificationResource.setGroupLocalService(this._groupLocalService);
        productSpecificationResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(RelatedProductResource relatedProductResource) throws Exception {
        relatedProductResource.setContextAcceptLanguage(this._acceptLanguage);
        relatedProductResource.setContextCompany(this._company);
        relatedProductResource.setContextHttpServletRequest(this._httpServletRequest);
        relatedProductResource.setContextHttpServletResponse(this._httpServletResponse);
        relatedProductResource.setContextUriInfo(this._uriInfo);
        relatedProductResource.setContextUser(this._user);
        relatedProductResource.setGroupLocalService(this._groupLocalService);
        relatedProductResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(SkuResource skuResource) throws Exception {
        skuResource.setContextAcceptLanguage(this._acceptLanguage);
        skuResource.setContextCompany(this._company);
        skuResource.setContextHttpServletRequest(this._httpServletRequest);
        skuResource.setContextHttpServletResponse(this._httpServletResponse);
        skuResource.setContextUriInfo(this._uriInfo);
        skuResource.setContextUser(this._user);
        skuResource.setGroupLocalService(this._groupLocalService);
        skuResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLName(value="SkuPage")
    public class SkuPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Sku> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public SkuPage(Page skuPage) {
            this.actions = skuPage.getActions();
            this.items = skuPage.getItems();
            this.lastPage = skuPage.getLastPage();
            this.page = skuPage.getPage();
            this.pageSize = skuPage.getPageSize();
            this.totalCount = skuPage.getTotalCount();
        }
    }

    @GraphQLName(value="RelatedProductPage")
    public class RelatedProductPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<RelatedProduct> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public RelatedProductPage(Page relatedProductPage) {
            this.actions = relatedProductPage.getActions();
            this.items = relatedProductPage.getItems();
            this.lastPage = relatedProductPage.getLastPage();
            this.page = relatedProductPage.getPage();
            this.pageSize = relatedProductPage.getPageSize();
            this.totalCount = relatedProductPage.getTotalCount();
        }
    }

    @GraphQLName(value="ProductSpecificationPage")
    public class ProductSpecificationPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<ProductSpecification> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ProductSpecificationPage(Page productSpecificationPage) {
            this.actions = productSpecificationPage.getActions();
            this.items = productSpecificationPage.getItems();
            this.lastPage = productSpecificationPage.getLastPage();
            this.page = productSpecificationPage.getPage();
            this.pageSize = productSpecificationPage.getPageSize();
            this.totalCount = productSpecificationPage.getTotalCount();
        }
    }

    @GraphQLName(value="ProductOptionPage")
    public class ProductOptionPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<ProductOption> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ProductOptionPage(Page productOptionPage) {
            this.actions = productOptionPage.getActions();
            this.items = productOptionPage.getItems();
            this.lastPage = productOptionPage.getLastPage();
            this.page = productOptionPage.getPage();
            this.pageSize = productOptionPage.getPageSize();
            this.totalCount = productOptionPage.getTotalCount();
        }
    }

    @GraphQLName(value="ProductPage")
    public class ProductPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Product> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public ProductPage(Page productPage) {
            this.actions = productPage.getActions();
            this.items = productPage.getItems();
            this.lastPage = productPage.getLastPage();
            this.page = productPage.getPage();
            this.pageSize = productPage.getPageSize();
            this.totalCount = productPage.getTotalCount();
        }
    }

    @GraphQLName(value="CategoryPage")
    public class CategoryPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Category> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public CategoryPage(Page categoryPage) {
            this.actions = categoryPage.getActions();
            this.items = categoryPage.getItems();
            this.lastPage = categoryPage.getLastPage();
            this.page = categoryPage.getPage();
            this.pageSize = categoryPage.getPageSize();
            this.totalCount = categoryPage.getTotalCount();
        }
    }

    @GraphQLName(value="AttachmentPage")
    public class AttachmentPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Attachment> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public AttachmentPage(Page attachmentPage) {
            this.actions = attachmentPage.getActions();
            this.items = attachmentPage.getItems();
            this.lastPage = attachmentPage.getLastPage();
            this.page = attachmentPage.getPage();
            this.pageSize = attachmentPage.getPageSize();
            this.totalCount = attachmentPage.getTotalCount();
        }
    }
}

