/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Availability;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Price;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.SkuDTOConverterContext;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=CPSku"}, service={DTOConverter.class, SkuDTOConverter.class})
public class SkuDTOConverter
implements DTOConverter<CPInstance, Sku> {
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @Reference
    private CPDefinitionInventoryEngine _cpDefinitionInventoryEngine;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private JsonHelper _jsonHelper;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Sku toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final SkuDTOConverterContext cpSkuDTOConverterConvertContext = (SkuDTOConverterContext)dtoConverterContext;
        final CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(((Long)cpSkuDTOConverterConvertContext.getId()).longValue());
        final CommerceContext commerceContext = cpSkuDTOConverterConvertContext.getCommerceContext();
        return new Sku(){
            {
                this.availability = SkuDTOConverter.this._getAvailability(cpSkuDTOConverterConvertContext.getCompanyId(), commerceContext.getCommerceChannelGroupId(), cpInstance.getSku(), cpInstance, cpSkuDTOConverterConvertContext.getLocale());
                this.depth = cpInstance.getDepth();
                this.displayDate = cpInstance.getDisplayDate();
                this.expirationDate = cpInstance.getExpirationDate();
                this.gtin = cpInstance.getGtin();
                this.height = cpInstance.getHeight();
                this.id = cpInstance.getCPInstanceId();
                this.manufacturerPartNumber = cpInstance.getManufacturerPartNumber();
                this.options = SkuDTOConverter.this._getOptions(cpInstance);
                this.price = SkuDTOConverter.this._getPrice(cpInstance, 1, cpSkuDTOConverterConvertContext.getCommerceContext(), cpSkuDTOConverterConvertContext.getLocale());
                this.published = cpInstance.isPublished();
                this.purchasable = cpInstance.isPurchasable();
                this.sku = cpInstance.getSku();
                this.weight = cpInstance.getWeight();
                this.width = cpInstance.getWidth();
            }
        };
    }

    private Availability _getAvailability(long companyId, long channelGroupId, String sku, CPInstance cpInstance, Locale locale) throws Exception {
        Availability availability = new Availability();
        int stockQuantity = this._commerceInventoryEngine.getStockQuantity(companyId, channelGroupId, sku);
        if (this._cpDefinitionInventoryEngine.isDisplayAvailability(cpInstance)) {
            if (stockQuantity > 0) {
                availability.setLabel(this._getLocalizedMessage(locale, "available"));
            } else {
                availability.setLabel(this._getLocalizedMessage(locale, "unavailable"));
            }
        }
        if (this._cpDefinitionInventoryEngine.isDisplayStockQuantity(cpInstance)) {
            availability.setStockQuantity(Integer.valueOf(stockQuantity));
        }
        return availability;
    }

    private String[] _getFormattedDiscountPercentages(BigDecimal[] discountPercentages, Locale locale) throws Exception {
        ArrayList<String> formattedDiscountPercentages = new ArrayList<String>();
        for (BigDecimal percentage : discountPercentages) {
            formattedDiscountPercentages.add(this._commercePriceFormatter.format(percentage, locale));
        }
        return formattedDiscountPercentages.toArray(new String[0]);
    }

    private String _getLocalizedMessage(Locale locale, String key) {
        ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)key);
    }

    private Map<String, String> _getOptions(CPInstance cpInstance) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        Map cpDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstance.getCPInstanceId());
        JSONArray keyValuesJSONArray = this._jsonHelper.toJSONArray(cpDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys);
        Map cpDefinitionOptionRelsMap = this._cpInstanceHelper.getCPDefinitionOptionRelsMap(cpInstance.getCPDefinitionId(), keyValuesJSONArray.toString());
        for (Map.Entry entry : cpDefinitionOptionRelsMap.entrySet()) {
            CPDefinitionOptionRel cpDefinitionOptionRel = (CPDefinitionOptionRel)entry.getKey();
            List cpDefinitionOptionValueRels = (List)entry.getValue();
            for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
                options.put(String.valueOf(cpDefinitionOptionRel.getCPDefinitionOptionRelId()), String.valueOf(cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId()));
            }
        }
        return options;
    }

    private Price _getPrice(CPInstance cpInstance, int quantity, CommerceContext commerceContext, final Locale locale) throws Exception {
        CommerceDiscountValue discountValue;
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(cpInstance.getCPInstanceId(), quantity, true, commerceContext);
        if (commerceProductPrice == null) {
            return new Price();
        }
        final CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        final CommerceMoney unitPriceMoney = commerceProductPrice.getUnitPrice();
        CommerceMoney unitPromoPriceMoney = commerceProductPrice.getUnitPromoPrice();
        BigDecimal unitPromoPrice = unitPromoPriceMoney.getPrice();
        final BigDecimal unitPrice = unitPriceMoney.getPrice();
        Price price = new Price(){
            {
                this.currency = commerceCurrency.getName(locale);
                this.price = unitPrice.doubleValue();
                this.priceFormatted = unitPriceMoney.format(locale);
            }
        };
        if (unitPromoPrice != null && unitPromoPrice.compareTo(BigDecimal.ZERO) > 0 && unitPromoPrice.compareTo(unitPriceMoney.getPrice()) < 0) {
            price.setPromoPrice(Double.valueOf(unitPromoPrice.doubleValue()));
            price.setPromoPriceFormatted(unitPromoPriceMoney.format(locale));
        }
        if ((discountValue = commerceProductPrice.getDiscountValue()) != null) {
            CommerceMoney discountAmount = discountValue.getDiscountAmount();
            CommerceMoney finalPrice = commerceProductPrice.getFinalPrice();
            price.setDiscount(discountAmount.format(locale));
            price.setDiscountPercentage(this._commercePriceFormatter.format(discountValue.getDiscountPercentage(), locale));
            price.setDiscountPercentages(this._getFormattedDiscountPercentages(discountValue.getPercentages(), locale));
            price.setFinalPrice(finalPrice.format(locale));
        }
        return price;
    }
}

