/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.ProductDTOConverterContext;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=CPDefinition"}, service={DTOConverter.class, ProductDTOConverter.class})
public class ProductDTOConverter
implements DTOConverter<CPDefinition, Product> {
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Product toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        ProductDTOConverterContext cpCatalogEntryDTOConverterConvertContext = (ProductDTOConverterContext)dtoConverterContext;
        final CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(((Long)cpCatalogEntryDTOConverterConvertContext.getId()).longValue());
        final String languageId = LanguageUtil.getLanguageId((Locale)cpCatalogEntryDTOConverterConvertContext.getLocale());
        final ExpandoBridge expandoBridge = cpDefinition.getExpandoBridge();
        Company company = this._companyLocalService.getCompany(cpDefinition.getCompanyId());
        final String portalURL = company.getPortalURL(0L);
        return new Product(){
            {
                this.createDate = cpDefinition.getCreateDate();
                this.description = cpDefinition.getDescription();
                this.expando = expandoBridge.getAttributes();
                this.id = cpDefinition.getCPDefinitionId();
                this.metaDescription = cpDefinition.getMetaDescription(languageId);
                this.metaKeyword = cpDefinition.getMetaKeywords(languageId);
                this.metaTitle = cpDefinition.getMetaTitle(languageId);
                this.modifiedDate = cpDefinition.getModifiedDate();
                this.name = cpDefinition.getName();
                this.productId = cpDefinition.getCProductId();
                this.productType = cpDefinition.getProductTypeName();
                this.shortDescription = cpDefinition.getShortDescription();
                this.slug = cpDefinition.getURL(languageId);
                this.tags = ProductDTOConverter.this._getTags(cpDefinition);
                this.urlImage = portalURL + cpDefinition.getDefaultImageFileURL();
            }
        };
    }

    private String[] _getTags(CPDefinition cpDefinition) {
        List assetEntryAssetTags = this._assetTagLocalService.getTags(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId());
        Stream stream = assetEntryAssetTags.stream();
        return (String[])stream.map(AssetTagModel::getName).toArray(String[]::new);
    }
}

