/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.site.setting.internal.util.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPMeasurementUnitException;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.product.service.CPMeasurementUnitService;
import com.liferay.headless.commerce.admin.site.setting.dto.v1_0.MeasurementUnit;
import com.liferay.headless.commerce.admin.site.setting.internal.mapper.v1_0.DTOMapper;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={MeasurementUnitHelper.class})
public class MeasurementUnitHelper {
    private static final Log _log = LogFactoryUtil.getLog(MeasurementUnitHelper.class);
    @Reference
    private CPMeasurementUnitService _cpMeasurementUnitService;
    @Reference
    private DTOMapper _dtoMapper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    public void deleteMeasurementUnit(Long id) throws PortalException {
        this._cpMeasurementUnitService.deleteCPMeasurementUnit(id.longValue());
    }

    public MeasurementUnit getMeasurementUnit(Long id) throws PortalException {
        return this._dtoMapper.modelToDTO(this._cpMeasurementUnitService.getCPMeasurementUnit(id.longValue()));
    }

    public Page<MeasurementUnit> getMeasurementUnits(Long companyId, Integer type, Pagination pagination) throws PortalException {
        int count;
        List cpMeasurementUnits;
        if (type == null) {
            cpMeasurementUnits = this._cpMeasurementUnitService.getCPMeasurementUnits(companyId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
            count = this._cpMeasurementUnitService.getCPMeasurementUnitsCount(companyId.longValue());
        } else {
            cpMeasurementUnits = this._cpMeasurementUnitService.getCPMeasurementUnits(companyId.longValue(), type.intValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
            count = this._cpMeasurementUnitService.getCPMeasurementUnitsCount(companyId.longValue(), type.intValue());
        }
        ArrayList<MeasurementUnit> measurementUnits = new ArrayList<MeasurementUnit>();
        for (CPMeasurementUnit cpMeasurementUnit : cpMeasurementUnits) {
            measurementUnits.add(this._dtoMapper.modelToDTO(cpMeasurementUnit));
        }
        return Page.of(measurementUnits, (Pagination)pagination, (long)count);
    }

    public CPMeasurementUnit updateMeasurementUnit(Long id, MeasurementUnit measurementUnit, User user) throws PortalException {
        CPMeasurementUnit cpMeasurementUnit = this._cpMeasurementUnitService.getCPMeasurementUnit(id.longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpMeasurementUnit.getGroupId(), new long[0], user, true);
        return this._cpMeasurementUnitService.updateCPMeasurementUnit(cpMeasurementUnit.getCPMeasurementUnitId(), LanguageUtils.getLocalizedMap((Map)measurementUnit.getName()), measurementUnit.getKey(), GetterUtil.get((Object)measurementUnit.getRate(), (double)cpMeasurementUnit.getRate()), GetterUtil.get((Object)measurementUnit.getPrimary(), (boolean)cpMeasurementUnit.isPrimary()), GetterUtil.get((Object)measurementUnit.getPriority(), (double)cpMeasurementUnit.getPriority()), GetterUtil.get((Object)measurementUnit.getType(), (int)cpMeasurementUnit.getType()), serviceContext);
    }

    public MeasurementUnit upsertMeasurementUnit(Long groupId, MeasurementUnit measurementUnit, User user) throws PortalException {
        try {
            CPMeasurementUnit cpMeasurementUnit = this.updateMeasurementUnit(measurementUnit.getId(), measurementUnit, user);
            return this._dtoMapper.modelToDTO(cpMeasurementUnit);
        }
        catch (NoSuchCPMeasurementUnitException noSuchCPMeasurementUnitException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find measurementUnit with ID: " + measurementUnit.getId()));
            }
            ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(groupId.longValue(), new long[0], user, true);
            CPMeasurementUnit cpMeasurementUnit = this._cpMeasurementUnitService.addCPMeasurementUnit(LanguageUtils.getLocalizedMap((Map)measurementUnit.getName()), measurementUnit.getKey(), GetterUtil.get((Object)measurementUnit.getRate(), (double)0.0), GetterUtil.get((Object)measurementUnit.getPrimary(), (boolean)false), GetterUtil.get((Object)measurementUnit.getPriority(), (double)0.0), GetterUtil.get((Object)measurementUnit.getType(), (int)0), serviceContext);
            return this._dtoMapper.modelToDTO(cpMeasurementUnit);
        }
    }
}

