/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.site.setting.internal.util.v1_0;

import com.liferay.commerce.exception.NoSuchAvailabilityEstimateException;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.service.CommerceAvailabilityEstimateService;
import com.liferay.headless.commerce.admin.site.setting.dto.v1_0.AvailabilityEstimate;
import com.liferay.headless.commerce.admin.site.setting.internal.mapper.v1_0.DTOMapper;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={AvailabilityEstimateHelper.class})
public class AvailabilityEstimateHelper {
    private static final Log _log = LogFactoryUtil.getLog(AvailabilityEstimateHelper.class);
    @Reference
    private CommerceAvailabilityEstimateService _commerceAvailabilityEstimateService;
    @Reference
    private DTOMapper _dtoMapper;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    public void deleteAvailabilityEstimate(Long id) throws PortalException {
        this._commerceAvailabilityEstimateService.deleteCommerceAvailabilityEstimate(id.longValue());
    }

    public AvailabilityEstimate getAvailabilityEstimate(Long id) throws PortalException {
        return this._dtoMapper.modelToDTO(this._commerceAvailabilityEstimateService.getCommerceAvailabilityEstimate(id.longValue()));
    }

    public Page<AvailabilityEstimate> getAvailabilityEstimates(Long companyId, Pagination pagination) throws PortalException {
        List commerceAvailabilityEstimates = this._commerceAvailabilityEstimateService.getCommerceAvailabilityEstimates(companyId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._commerceAvailabilityEstimateService.getCommerceAvailabilityEstimatesCount(companyId.longValue());
        ArrayList<AvailabilityEstimate> availabilityEstimates = new ArrayList<AvailabilityEstimate>();
        for (CommerceAvailabilityEstimate commerceAvailabilityEstimate : commerceAvailabilityEstimates) {
            availabilityEstimates.add(this._dtoMapper.modelToDTO(commerceAvailabilityEstimate));
        }
        return Page.of(availabilityEstimates, (Pagination)pagination, (long)count);
    }

    public CommerceAvailabilityEstimate updateAvailabilityEstimate(Long id, AvailabilityEstimate availabilityEstimate, User user) throws PortalException {
        CommerceAvailabilityEstimate commerceAvailabilityEstimate = this._commerceAvailabilityEstimateService.getCommerceAvailabilityEstimate(id.longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(0L, new long[0], user, true);
        return this._commerceAvailabilityEstimateService.updateCommerceAvailabilityEstimate(commerceAvailabilityEstimate.getCommerceAvailabilityEstimateId(), LanguageUtils.getLocalizedMap((Map)availabilityEstimate.getTitle()), GetterUtil.get((Object)availabilityEstimate.getPriority(), (double)commerceAvailabilityEstimate.getPriority()), serviceContext);
    }

    public AvailabilityEstimate upsertAvailabilityEstimate(Long groupId, AvailabilityEstimate availabilityEstimate, User user) throws PortalException {
        try {
            CommerceAvailabilityEstimate commerceAvailabilityEstimate = this.updateAvailabilityEstimate(availabilityEstimate.getId(), availabilityEstimate, user);
            return this._dtoMapper.modelToDTO(commerceAvailabilityEstimate);
        }
        catch (NoSuchAvailabilityEstimateException noSuchAvailabilityEstimateException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find availabilityEstimate with ID: " + availabilityEstimate.getId()));
            }
            ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(groupId.longValue(), new long[0], user, true);
            CommerceAvailabilityEstimate commerceAvailabilityEstimate = this._commerceAvailabilityEstimateService.addCommerceAvailabilityEstimate(LanguageUtils.getLocalizedMap((Map)availabilityEstimate.getTitle()), GetterUtil.get((Object)availabilityEstimate.getPriority(), (double)0.0), serviceContext);
            return this._dtoMapper.modelToDTO(commerceAvailabilityEstimate);
        }
    }
}

