/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.site.setting.client.resource.v1_0;

import com.liferay.headless.commerce.admin.site.setting.client.dto.v1_0.MeasurementUnit;
import com.liferay.headless.commerce.admin.site.setting.client.http.HttpInvoker;
import com.liferay.headless.commerce.admin.site.setting.client.pagination.Page;
import com.liferay.headless.commerce.admin.site.setting.client.pagination.Pagination;
import com.liferay.headless.commerce.admin.site.setting.client.problem.Problem;
import com.liferay.headless.commerce.admin.site.setting.client.serdes.v1_0.MeasurementUnitSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface MeasurementUnitResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<MeasurementUnit> getCommerceAdminSiteSettingGroupMeasurementUnitPage(Long var1, Integer var2, Pagination var3) throws Exception;

    public HttpInvoker.HttpResponse getCommerceAdminSiteSettingGroupMeasurementUnitPageHttpResponse(Long var1, Integer var2, Pagination var3) throws Exception;

    public MeasurementUnit postCommerceAdminSiteSettingGroupMeasurementUnit(Long var1, MeasurementUnit var2) throws Exception;

    public HttpInvoker.HttpResponse postCommerceAdminSiteSettingGroupMeasurementUnitHttpResponse(Long var1, MeasurementUnit var2) throws Exception;

    public void deleteMeasurementUnit(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteMeasurementUnitHttpResponse(Long var1) throws Exception;

    public void deleteMeasurementUnitBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse deleteMeasurementUnitBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public MeasurementUnit getMeasurementUnit(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getMeasurementUnitHttpResponse(Long var1) throws Exception;

    public void putMeasurementUnit(Long var1, MeasurementUnit var2) throws Exception;

    public HttpInvoker.HttpResponse putMeasurementUnitHttpResponse(Long var1, MeasurementUnit var2) throws Exception;

    public void putMeasurementUnitBatch(Long var1, String var2, Object var3) throws Exception;

    public HttpInvoker.HttpResponse putMeasurementUnitBatchHttpResponse(Long var1, String var2, Object var3) throws Exception;

    public static class MeasurementUnitResourceImpl
    implements MeasurementUnitResource {
        private static final Logger _logger = Logger.getLogger(MeasurementUnitResource.class.getName());
        private Builder _builder;

        @Override
        public Page<MeasurementUnit> getCommerceAdminSiteSettingGroupMeasurementUnitPage(Long groupId, Integer type, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getCommerceAdminSiteSettingGroupMeasurementUnitPageHttpResponse(groupId, type, pagination);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, MeasurementUnitSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getCommerceAdminSiteSettingGroupMeasurementUnitPageHttpResponse(Long groupId, Integer type, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (type != null) {
                httpInvoker.parameter("type", String.valueOf(type));
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-site-setting/v1.0/commerceAdminSiteSetting/{groupId}/measurementUnit", groupId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public MeasurementUnit postCommerceAdminSiteSettingGroupMeasurementUnit(Long groupId, MeasurementUnit measurementUnit) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postCommerceAdminSiteSettingGroupMeasurementUnitHttpResponse(groupId, measurementUnit);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return MeasurementUnitSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postCommerceAdminSiteSettingGroupMeasurementUnitHttpResponse(Long groupId, MeasurementUnit measurementUnit) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(measurementUnit.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-site-setting/v1.0/commerceAdminSiteSetting/{groupId}/measurementUnit", groupId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteMeasurementUnit(Long id) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteMeasurementUnitHttpResponse(id);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteMeasurementUnitHttpResponse(Long id) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-site-setting/v1.0/measurementUnit/{id}", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteMeasurementUnitBatch(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteMeasurementUnitBatchHttpResponse(id, callbackURL, object);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteMeasurementUnitBatchHttpResponse(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-site-setting/v1.0/measurementUnit/{id}/batch", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public MeasurementUnit getMeasurementUnit(Long id) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getMeasurementUnitHttpResponse(id);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return MeasurementUnitSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getMeasurementUnitHttpResponse(Long id) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-site-setting/v1.0/measurementUnit/{id}", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void putMeasurementUnit(Long id, MeasurementUnit measurementUnit) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putMeasurementUnitHttpResponse(id, measurementUnit);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse putMeasurementUnitHttpResponse(Long id, MeasurementUnit measurementUnit) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(measurementUnit.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-site-setting/v1.0/measurementUnit/{id}", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void putMeasurementUnitBatch(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putMeasurementUnitBatchHttpResponse(id, callbackURL, object);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse putMeasurementUnitBatchHttpResponse(Long id, String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/headless-commerce-admin-site-setting/v1.0/measurementUnit/{id}/batch", id);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private MeasurementUnitResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public MeasurementUnitResource build() {
            return new MeasurementUnitResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        private Builder() {
        }
    }
}

