/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.util.v2_0;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.pricing.exception.NoSuchPricingClassException;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountProductGroup;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;

public class DiscountProductGroupUtil {
    public static CommerceDiscountRel addCommerceDiscountRel(CommercePricingClassService commercePricingClassService, CommerceDiscountRelService commerceDiscountRelService, DiscountProductGroup discountProductGroup, CommerceDiscount commerceDiscount, ServiceContextHelper serviceContextHelper) throws PortalException {
        CommercePricingClass commercePricingClass;
        ServiceContext serviceContext = serviceContextHelper.getServiceContext();
        if (Validator.isNull((String)discountProductGroup.getProductGroupExternalReferenceCode())) {
            commercePricingClass = commercePricingClassService.getCommercePricingClass(discountProductGroup.getProductGroupId().longValue());
        } else {
            commercePricingClass = commercePricingClassService.fetchByExternalReferenceCode(discountProductGroup.getProductGroupExternalReferenceCode(), serviceContext.getCompanyId());
            if (commercePricingClass == null) {
                String productGroupExternalReferenceCode = discountProductGroup.getProductGroupExternalReferenceCode();
                throw new NoSuchPricingClassException("Unable to find product group with external reference code " + productGroupExternalReferenceCode);
            }
        }
        return commerceDiscountRelService.addCommerceDiscountRel(commerceDiscount.getCommerceDiscountId(), CommercePricingClass.class.getName(), commercePricingClass.getCommercePricingClassId(), serviceContext);
    }
}

