/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.pricing.model.CommercePriceModifierRel;
import com.liferay.commerce.pricing.service.CommercePriceModifierRelService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountProduct;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceEntry;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceModifierProduct;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Product;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.ProductDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseProductResourceImpl;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.ProductResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/product.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, ProductResource.class})
public class ProductResourceImpl
extends BaseProductResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceModifierRelService _commercePriceModifierRelService;
    @Reference
    private ProductDTOConverter _productDTOConverter;

    @Override
    @NestedField(parentClass=DiscountProduct.class, value="product")
    public Product getDiscountProductProduct(Long id) throws Exception {
        CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.getCommerceDiscountRel(id.longValue());
        return this._productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceDiscountRel.getClassPK(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=PriceEntry.class, value="product")
    public Product getPriceEntryIdProduct(Long id) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getCommercePriceEntry(id.longValue());
        CPInstance cpInstance = commercePriceEntry.getCPInstance();
        return this._productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpInstance.getCPDefinitionId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=PriceModifierProduct.class, value="product")
    public Product getPriceModifierProductProduct(Long id) throws Exception {
        CommercePriceModifierRel commercePriceModifierRel = this._commercePriceModifierRelService.getCommercePriceModifierRel(id.longValue());
        return this._productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commercePriceModifierRel.getClassPK(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

