/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListOrderTypeRel;
import com.liferay.commerce.price.list.service.CommercePriceListOrderTypeRelService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceList;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceListOrderType;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceListOrderTypeDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceListOrderTypeResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceListOrderTypeUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceListOrderTypeResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/price-list-order-type.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, PriceListOrderTypeResource.class})
public class PriceListOrderTypeResourceImpl
extends BasePriceListOrderTypeResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference(target="(model.class.name=com.liferay.commerce.price.list.model.CommercePriceListOrderTypeRel)")
    private ModelResourcePermission<CommercePriceListOrderTypeRel> _commercePriceListOrderTypeRelModelResourcePermission;
    @Reference
    private CommercePriceListOrderTypeRelService _commercePriceListOrderTypeRelService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceListOrderTypeDTOConverter _priceListOrderTypeDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceListOrderType(Long id) throws Exception {
        this._commercePriceListOrderTypeRelService.deleteCommercePriceListOrderTypeRel(id.longValue());
    }

    @Override
    public Page<PriceListOrderType> getPriceListByExternalReferenceCodePriceListOrderTypesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._commercePriceListOrderTypeRelService.getCommercePriceListOrderTypeRels(commercePriceList.getCommercePriceListId(), "", pagination.getStartPosition(), pagination.getEndPosition(), null), commercePriceListOrderTypeRel -> this._toPriceListOrderType(commercePriceListOrderTypeRel.getCommercePriceListOrderTypeRelId())), (Pagination)pagination, (long)this._commercePriceListOrderTypeRelService.getCommercePriceListOrderTypeRelsCount(commercePriceList.getCommercePriceListId(), ""));
    }

    @Override
    @NestedField(parentClass=PriceList.class, value="priceListOrderTypes")
    public Page<PriceListOrderType> getPriceListIdPriceListOrderTypesPage(Long id, String search, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._commercePriceListOrderTypeRelService.getCommercePriceListOrderTypeRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition(), null), commercePriceListOrderTypeRel -> this._toPriceListOrderType(commercePriceListOrderTypeRel.getCommercePriceListOrderTypeRelId())), (Pagination)pagination, (long)this._commercePriceListOrderTypeRelService.getCommercePriceListOrderTypeRelsCount(id.longValue(), search));
    }

    @Override
    public PriceListOrderType postPriceListByExternalReferenceCodePriceListOrderType(String externalReferenceCode, PriceListOrderType priceListOrderType) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        CommercePriceListOrderTypeRel commercePriceListOrderTypeRel = PriceListOrderTypeUtil.addCommercePriceListOrderTypeRel(this._commerceOrderTypeService, this._commercePriceListOrderTypeRelService, priceListOrderType, commercePriceList, this._serviceContextHelper);
        return this._toPriceListOrderType(commercePriceListOrderTypeRel.getCommercePriceListOrderTypeRelId());
    }

    @Override
    public PriceListOrderType postPriceListIdPriceListOrderType(Long id, PriceListOrderType priceListOrderType) throws Exception {
        CommercePriceListOrderTypeRel commercePriceListOrderTypeRel = PriceListOrderTypeUtil.addCommercePriceListOrderTypeRel(this._commerceOrderTypeService, this._commercePriceListOrderTypeRelService, priceListOrderType, this._commercePriceListService.getCommercePriceList(id.longValue()), this._serviceContextHelper);
        return this._toPriceListOrderType(commercePriceListOrderTypeRel.getCommercePriceListOrderTypeRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceListOrderTypeRel commercePriceListOrderTypeRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commercePriceListOrderTypeRel.getCommercePriceListOrderTypeRelId(), "deletePriceListOrderType", this._commercePriceListOrderTypeRelModelResourcePermission)).build();
    }

    private PriceListOrderType _toPriceListOrderType(Long commercePriceListOrderTypeRelId) throws Exception {
        CommercePriceListOrderTypeRel commercePriceListOrderTypeRel = this._commercePriceListOrderTypeRelService.getCommercePriceListOrderTypeRel(commercePriceListOrderTypeRelId.longValue());
        return this._priceListOrderTypeDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceListOrderTypeRel), this._dtoConverterRegistry, (Object)commercePriceListOrderTypeRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

