/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListAccountRel;
import com.liferay.commerce.price.list.service.CommercePriceListAccountRelService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceList;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceListAccount;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceListAccountDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceListAccountResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceListAccountUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceListAccountResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/price-list-account.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, PriceListAccountResource.class})
public class PriceListAccountResourceImpl
extends BasePriceListAccountResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference(target="(model.class.name=com.liferay.commerce.price.list.model.CommercePriceListAccountRel)")
    private ModelResourcePermission<CommercePriceListAccountRel> _commercePriceListAccountRelModelResourcePermission;
    @Reference
    private CommercePriceListAccountRelService _commercePriceListAccountRelService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceListAccountDTOConverter _priceListAccountDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceListAccount(Long id) throws Exception {
        this._commercePriceListAccountRelService.deleteCommercePriceListAccountRel(id.longValue());
    }

    @Override
    public Page<PriceListAccount> getPriceListByExternalReferenceCodePriceListAccountsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        List commercePriceListAccountRels = this._commercePriceListAccountRelService.getCommercePriceListAccountRels(commercePriceList.getCommercePriceListId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceListAccountRelService.getCommercePriceListAccountRelsCount(commercePriceList.getCommercePriceListId());
        return Page.of(this._toPriceListAccounts(commercePriceListAccountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=PriceList.class, value="priceListAccounts")
    public Page<PriceListAccount> getPriceListIdPriceListAccountsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commercePriceListAccountRels = this._commercePriceListAccountRelService.getCommercePriceListAccountRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commercePriceListAccountRelService.getCommercePriceListAccountRelsCount(id.longValue(), search);
        return Page.of(this._toPriceListAccounts(commercePriceListAccountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public PriceListAccount postPriceListByExternalReferenceCodePriceListAccount(String externalReferenceCode, PriceListAccount priceListAccount) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        CommercePriceListAccountRel commercePriceListAccountRel = PriceListAccountUtil.addCommercePriceListAccountRel(this._commerceAccountService, this._commercePriceListAccountRelService, priceListAccount, commercePriceList, this._serviceContextHelper);
        return this._toPriceListAccount(commercePriceListAccountRel.getCommercePriceListAccountRelId());
    }

    @Override
    public PriceListAccount postPriceListIdPriceListAccount(Long id, PriceListAccount priceListAccount) throws Exception {
        CommercePriceListAccountRel commercePriceListAccountRel = PriceListAccountUtil.addCommercePriceListAccountRel(this._commerceAccountService, this._commercePriceListAccountRelService, priceListAccount, this._commercePriceListService.getCommercePriceList(id.longValue()), this._serviceContextHelper);
        return this._toPriceListAccount(commercePriceListAccountRel.getCommercePriceListAccountRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceListAccountRel commercePriceListAccountRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commercePriceListAccountRel.getCommercePriceListAccountRelId(), "deletePriceListAccount", this._commercePriceListAccountRelModelResourcePermission)).build();
    }

    private PriceListAccount _toPriceListAccount(Long commercePriceListAccountRelId) throws Exception {
        CommercePriceListAccountRel commercePriceListAccountRel = this._commercePriceListAccountRelService.getCommercePriceListAccountRel(commercePriceListAccountRelId.longValue());
        return this._priceListAccountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceListAccountRel), this._dtoConverterRegistry, (Object)commercePriceListAccountRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<PriceListAccount> _toPriceListAccounts(List<CommercePriceListAccountRel> commercePriceListAccountRels) throws Exception {
        ArrayList<PriceListAccount> priceListAccounts = new ArrayList<PriceListAccount>();
        for (CommercePriceListAccountRel commercePriceListAccountRel : commercePriceListAccountRels) {
            priceListAccounts.add(this._toPriceListAccount(commercePriceListAccountRel.getCommercePriceListAccountRelId()));
        }
        return priceListAccounts;
    }
}

