/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Discount;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountChannel;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountChannelDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountChannelResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountChannelUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountChannelResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/discount-channel.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountChannelResource.class, NestedFieldSupport.class})
public class DiscountChannelResourceImpl
extends BaseDiscountChannelResourceImpl
implements NestedFieldSupport {
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceChannelRel)")
    private ModelResourcePermission<CommerceChannelRel> _commerceChannelRelModelResourcePermission;
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private DiscountChannelDTOConverter _discountChannelDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscountChannel(Long id) throws Exception {
        this._commerceChannelRelService.deleteCommerceChannelRel(id.longValue());
    }

    @Override
    public Page<DiscountChannel> getDiscountByExternalReferenceCodeDiscountChannelsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find discount with external reference code " + externalReferenceCode);
        }
        List commerceChannelRels = this._commerceChannelRelService.getCommerceChannelRels(CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId(), null, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceChannelRelService.getCommerceChannelRelsCount(CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId());
        return Page.of(this._toDiscountChannels(commerceChannelRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Discount.class, value="discountChannels")
    public Page<DiscountChannel> getDiscountIdDiscountChannelsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchCommerceDiscount(id.longValue());
        if (commerceDiscount == null) {
            return Page.of(Collections.emptyList());
        }
        List commerceChannelRel = this._commerceChannelRelService.getCommerceChannelRels(CommerceDiscount.class.getName(), id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceChannelRelService.getCommerceChannelRelsCount(CommerceDiscount.class.getName(), id.longValue(), search);
        return Page.of(this._toDiscountChannels(commerceChannelRel), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountChannel postDiscountByExternalReferenceCodeDiscountChannel(String externalReferenceCode, DiscountChannel discountChannel) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find discount with external reference code " + externalReferenceCode);
        }
        CommerceChannelRel commerceChannelRel = DiscountChannelUtil.addCommerceDiscountChannelRel(this._commerceChannelService, this._commerceChannelRelService, discountChannel, commerceDiscount, this._serviceContextHelper);
        return this._toDiscountChannel(commerceChannelRel.getCommerceChannelRelId());
    }

    @Override
    public DiscountChannel postDiscountIdDiscountChannel(Long id, DiscountChannel discountChannel) throws Exception {
        CommerceChannelRel commerceChannelRel = DiscountChannelUtil.addCommerceDiscountChannelRel(this._commerceChannelService, this._commerceChannelRelService, discountChannel, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper);
        return this._toDiscountChannel(commerceChannelRel.getCommerceChannelRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceChannelRel commerceChannelRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceChannelRel.getCommerceChannelRelId(), "deleteDiscountChannel", this._commerceChannelRelModelResourcePermission)).build();
    }

    private DiscountChannel _toDiscountChannel(Long commerceChannelRelId) throws Exception {
        CommerceChannelRel commerceChannelRel = this._commerceChannelRelService.getCommerceChannelRel(commerceChannelRelId.longValue());
        return this._discountChannelDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceChannelRel), this._dtoConverterRegistry, (Object)commerceChannelRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<DiscountChannel> _toDiscountChannels(List<CommerceChannelRel> commerceChannelRels) throws Exception {
        ArrayList<DiscountChannel> discountChannels = new ArrayList<DiscountChannel>();
        for (CommerceChannelRel commerceChannelRel : commerceChannelRels) {
            discountChannels.add(this._toDiscountChannel(commerceChannelRel.getCommerceChannelRelId()));
        }
        return discountChannels;
    }
}

