/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Discount;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountCategory;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountCategoryDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountCategoryResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountCategoryUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountCategoryResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/discount-category.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountCategoryResource.class, NestedFieldSupport.class})
public class DiscountCategoryResourceImpl
extends BaseDiscountCategoryResourceImpl
implements NestedFieldSupport {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.discount.model.CommerceDiscountRel)")
    private ModelResourcePermission<CommerceDiscountRel> _commerceDiscountRelModelResourcePermission;
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private DiscountCategoryDTOConverter _discountCategoryDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscountCategory(Long id) throws Exception {
        this._commerceDiscountRelService.deleteCommerceDiscountRel(id.longValue());
    }

    @Override
    public Page<DiscountCategory> getDiscountByExternalReferenceCodeDiscountCategoriesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find discount with external reference code " + externalReferenceCode);
        }
        List commerceDiscountRels = this._commerceDiscountRelService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), AssetCategory.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRelService.getCommerceDiscountRelsCount(commerceDiscount.getCommerceDiscountId(), AssetCategory.class.getName());
        return Page.of(this._toDiscountCategories(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Discount.class, value="discountCategories")
    public Page<DiscountCategory> getDiscountIdDiscountCategoriesPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commerceDiscountRels = this._commerceDiscountRelService.getCategoriesByCommerceDiscountId(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceDiscountRelService.getCategoriesByCommerceDiscountIdCount(id.longValue(), search);
        return Page.of(this._toDiscountCategories(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountCategory postDiscountByExternalReferenceCodeDiscountCategory(String externalReferenceCode, DiscountCategory discountCategory) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find discount with external reference code " + externalReferenceCode);
        }
        CommerceDiscountRel commerceDiscountRel = DiscountCategoryUtil.addCommerceDiscountRel(this.contextCompany.getGroupId(), this._assetCategoryLocalService, this._commerceDiscountRelService, discountCategory, commerceDiscount, this._serviceContextHelper);
        return this._toDiscountCategory(commerceDiscountRel.getCommerceDiscountRelId());
    }

    @Override
    public DiscountCategory postDiscountIdDiscountCategory(Long id, DiscountCategory discountCategory) throws Exception {
        CommerceDiscountRel commerceDiscountRel = DiscountCategoryUtil.addCommerceDiscountRel(this.contextCompany.getGroupId(), this._assetCategoryLocalService, this._commerceDiscountRelService, discountCategory, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper);
        return this._toDiscountCategory(commerceDiscountRel.getCommerceDiscountRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceDiscountRel commerceDiscountRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceDiscountRel.getCommerceDiscountRelId(), "deleteDiscountCategory", this._commerceDiscountRelModelResourcePermission)).build();
    }

    private List<DiscountCategory> _toDiscountCategories(List<CommerceDiscountRel> commerceDiscountRels) throws Exception {
        ArrayList<DiscountCategory> discountCategories = new ArrayList<DiscountCategory>();
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            discountCategories.add(this._toDiscountCategory(commerceDiscountRel.getCommerceDiscountRelId()));
        }
        return discountCategories;
    }

    private DiscountCategory _toDiscountCategory(Long commerceDiscountRelId) throws Exception {
        CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.getCommerceDiscountRel(commerceDiscountRelId.longValue());
        return this._discountCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceDiscountRel), this._dtoConverterRegistry, (Object)commerceDiscountRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

