/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0;

import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListCommerceAccountGroupRel;
import com.liferay.commerce.price.list.service.CommercePriceListCommerceAccountGroupRelService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.PriceListAccountGroup;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter.PriceListAccountGroupDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0.BasePriceListAccountGroupResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.PriceListAccountGroupUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v1_0.PriceListAccountGroupResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/price-list-account-group.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceListAccountGroupResource.class})
public class PriceListAccountGroupResourceImpl
extends BasePriceListAccountGroupResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private CommercePriceListCommerceAccountGroupRelService _commercePriceListCommerceAccountGroupRelService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private PriceListAccountGroupDTOConverter _priceListAccountGroupDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deletePriceListAccountGroup(Long id) throws Exception {
        this._commercePriceListCommerceAccountGroupRelService.deleteCommercePriceListCommerceAccountGroupRel(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<PriceListAccountGroup> getPriceListByExternalReferenceCodePriceListAccountGroupPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        List commercePriceListCommerceAccountGroupRels = this._commercePriceListCommerceAccountGroupRelService.getCommercePriceListCommerceAccountGroupRels(commercePriceList.getCommercePriceListId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceListCommerceAccountGroupRelService.getCommercePriceListCommerceAccountGroupRelsCount(commercePriceList.getCommercePriceListId());
        return Page.of(this._toPriceListAccountGroups(commercePriceListCommerceAccountGroupRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<PriceListAccountGroup> getPriceListIdPriceListAccountGroupsPage(Long id, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchCommercePriceList(id.longValue());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with id: " + id);
        }
        List commercePriceListCommerceAccountGroupRels = this._commercePriceListCommerceAccountGroupRelService.getCommercePriceListCommerceAccountGroupRels(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceListCommerceAccountGroupRelService.getCommercePriceListCommerceAccountGroupRelsCount(id.longValue());
        return Page.of(this._toPriceListAccountGroups(commercePriceListCommerceAccountGroupRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public PriceListAccountGroup postPriceListByExternalReferenceCodePriceListAccountGroup(String externalReferenceCode, PriceListAccountGroup priceListAccountGroup) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        CommercePriceListCommerceAccountGroupRel commercePriceListCommerceAccountGroupRel = PriceListAccountGroupUtil.addCommercePriceListCommerceAccountGroupRel(this._commerceAccountGroupService, this._commercePriceListCommerceAccountGroupRelService, priceListAccountGroup, commercePriceList, this._serviceContextHelper.getServiceContext(commercePriceList.getGroupId()));
        return this._toPriceListAccountGroup(commercePriceListCommerceAccountGroupRel.getCommercePriceListCommerceAccountGroupRelId());
    }

    @Override
    public PriceListAccountGroup postPriceListIdPriceListAccountGroup(Long id, PriceListAccountGroup priceListAccountGroup) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.getCommercePriceList(id.longValue());
        CommercePriceListCommerceAccountGroupRel commercePriceListCommerceAccountGroupRel = PriceListAccountGroupUtil.addCommercePriceListCommerceAccountGroupRel(this._commerceAccountGroupService, this._commercePriceListCommerceAccountGroupRelService, priceListAccountGroup, commercePriceList, this._serviceContextHelper.getServiceContext(commercePriceList.getGroupId()));
        return this._toPriceListAccountGroup(commercePriceListCommerceAccountGroupRel.getCommercePriceListCommerceAccountGroupRelId());
    }

    private PriceListAccountGroup _toPriceListAccountGroup(Long commercePriceListCommerceAccountGroupRelId) throws Exception {
        return this._priceListAccountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commercePriceListCommerceAccountGroupRelId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<PriceListAccountGroup> _toPriceListAccountGroups(List<CommercePriceListCommerceAccountGroupRel> commercePriceListCommerceAccountGroupRels) throws Exception {
        ArrayList<PriceListAccountGroup> priceListAccountGroups = new ArrayList<PriceListAccountGroup>();
        for (CommercePriceListCommerceAccountGroupRel commercePriceListCommerceAccountGroupRel : commercePriceListCommerceAccountGroupRels) {
            priceListAccountGroups.add(this._toPriceListAccountGroup(commercePriceListCommerceAccountGroupRel.getCommercePriceListCommerceAccountGroupRelId()));
        }
        return priceListAccountGroups;
    }
}

