/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountSku;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.discount.model.CommerceDiscountRel-Sku"}, service={DiscountSkuDTOConverter.class, DTOConverter.class})
public class DiscountSkuDTOConverter
implements DTOConverter<CommerceDiscountRel, DiscountSku> {
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CPInstanceService _cpInstanceService;

    public String getContentType() {
        return DiscountSku.class.getSimpleName();
    }

    public DiscountSku toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.getCommerceDiscountRel(((Long)dtoConverterContext.getId()).longValue());
        final CommerceDiscount commerceDiscount = commerceDiscountRel.getCommerceDiscount();
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(commerceDiscountRel.getClassPK());
        final CPDefinition cpDefinition = cpInstance.getCPDefinition();
        return new DiscountSku(){
            {
                this.actions = dtoConverterContext.getActions();
                this.discountExternalReferenceCode = commerceDiscount.getExternalReferenceCode();
                this.discountId = commerceDiscount.getCommerceDiscountId();
                this.discountSkuId = commerceDiscountRel.getCommerceDiscountRelId();
                this.productId = cpDefinition.getCPDefinitionId();
                this.productName = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                this.skuExternalReferenceCode = cpInstance.getExternalReferenceCode();
                this.skuId = cpInstance.getCPInstanceId();
            }
        };
    }
}

