/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountProduct;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.discount.model.CommerceDiscountRel-Product"}, service={DiscountProductDTOConverter.class, DTOConverter.class})
public class DiscountProductDTOConverter
implements DTOConverter<CommerceDiscountRel, DiscountProduct> {
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public String getContentType() {
        return DiscountProduct.class.getSimpleName();
    }

    public DiscountProduct toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.getCommerceDiscountRel(((Long)dtoConverterContext.getId()).longValue());
        CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(commerceDiscountRel.getClassPK());
        final CProduct cProduct = cpDefinition.getCProduct();
        final CommerceDiscount commerceDiscount = commerceDiscountRel.getCommerceDiscount();
        return new DiscountProduct(){
            {
                this.actions = dtoConverterContext.getActions();
                this.discountExternalReferenceCode = commerceDiscount.getExternalReferenceCode();
                this.discountId = commerceDiscount.getCommerceDiscountId();
                this.discountProductId = commerceDiscountRel.getCommerceDiscountRelId();
                this.productExternalReferenceCode = cProduct.getExternalReferenceCode();
                this.productId = cProduct.getCProductId();
            }
        };
    }
}

