/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Account;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.account.model.CommerceAccount"}, service={AccountDTOConverter.class, DTOConverter.class})
public class AccountDTOConverter
implements DTOConverter<CommerceAccount, Account> {
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public Account toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        CommerceAccount commerceAccount;
        if ((Long)dtoConverterContext.getId() == -1L) {
            User user = dtoConverterContext.getUser();
            if (user == null) {
                user = this._userLocalService.getUserById(PrincipalThreadLocal.getUserId());
            }
            commerceAccount = this._commerceAccountLocalService.getGuestCommerceAccount(user.getCompanyId());
        } else {
            commerceAccount = this._commerceAccountService.getCommerceAccount(((Long)dtoConverterContext.getId()).longValue());
        }
        return new Account(){
            {
                this.id = commerceAccount.getCommerceAccountId();
                this.logoId = commerceAccount.getLogoId();
                this.name = commerceAccount.getName();
            }
        };
    }
}

