/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.pricing.exception.NoSuchPriceModifierException;
import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.model.CommercePriceModifierRel;
import com.liferay.commerce.pricing.service.CommercePriceModifierRelService;
import com.liferay.commerce.pricing.service.CommercePriceModifierService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceModifierProduct;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceModifierProductDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceModifierProductResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceModifierProductUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceModifierProductResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/price-modifier-product.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceModifierProductResource.class})
public class PriceModifierProductResourceImpl
extends BasePriceModifierProductResourceImpl {
    @Reference
    private CommercePriceModifierRelService _commercePriceModifierRelService;
    @Reference
    private CommercePriceModifierService _commercePriceModifierService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceModifierProductDTOConverter _priceModifierProductDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceModifierProduct(Long id) throws Exception {
        this._commercePriceModifierRelService.deleteCommercePriceModifierRel(id.longValue());
    }

    @Override
    public Page<PriceModifierProduct> getPriceModifierByExternalReferenceCodePriceModifierProductsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find Price Modifier with externalReferenceCode: " + externalReferenceCode);
        }
        List commercePriceModifierRels = this._commercePriceModifierRelService.getCommercePriceModifierRels(commercePriceModifier.getCommercePriceModifierId(), CPDefinition.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceModifierRelService.getCommercePriceModifierRelsCount(commercePriceModifier.getCommercePriceModifierId(), CPDefinition.class.getName());
        return Page.of(this._toPriceModifierProducts(commercePriceModifierRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<PriceModifierProduct> getPriceModifierIdPriceModifierProductsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Locale locale = this.contextAcceptLanguage.getPreferredLocale();
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        List commercePriceModifierRels = this._commercePriceModifierRelService.getCPDefinitionsCommercePriceModifierRels(id.longValue(), search, languageId, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commercePriceModifierRelService.getCPDefinitionsCommercePriceModifierRelsCount(id.longValue(), search, languageId);
        return Page.of(this._toPriceModifierProducts(commercePriceModifierRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public PriceModifierProduct postPriceModifierByExternalReferenceCodePriceModifierProduct(String externalReferenceCode, PriceModifierProduct priceModifierProduct) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find Price Modifier with externalReferenceCode: " + externalReferenceCode);
        }
        CommercePriceModifierRel commercePriceModifierRel = PriceModifierProductUtil.addCommercePriceModifierRel(this._cProductLocalService, this._commercePriceModifierRelService, priceModifierProduct, commercePriceModifier, this._serviceContextHelper);
        return this._toPriceModifierProduct(commercePriceModifierRel.getCommercePriceModifierRelId());
    }

    @Override
    public PriceModifierProduct postPriceModifierIdPriceModifierProduct(Long id, PriceModifierProduct priceModifierProduct) throws Exception {
        CommercePriceModifierRel commercePriceModifierRel = PriceModifierProductUtil.addCommercePriceModifierRel(this._cProductLocalService, this._commercePriceModifierRelService, priceModifierProduct, this._commercePriceModifierService.getCommercePriceModifier(id.longValue()), this._serviceContextHelper);
        return this._toPriceModifierProduct(commercePriceModifierRel.getCommercePriceModifierRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceModifierRel commercePriceModifierRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", () -> {
            CommercePriceModifier commercePriceModifier = commercePriceModifierRel.getCommercePriceModifier();
            return this.addAction("UPDATE", commercePriceModifier.getCommercePriceListId(), "deletePriceModifierProduct", commercePriceModifier.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceModifier.getGroupId());
        }).build();
    }

    private PriceModifierProduct _toPriceModifierProduct(Long commercePriceModifierRelId) throws Exception {
        CommercePriceModifierRel commercePriceModifierRel = this._commercePriceModifierRelService.getCommercePriceModifierRel(commercePriceModifierRelId.longValue());
        return this._priceModifierProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceModifierRel), this._dtoConverterRegistry, (Object)commercePriceModifierRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<PriceModifierProduct> _toPriceModifierProducts(List<CommercePriceModifierRel> commercePriceModifierRels) throws Exception {
        ArrayList<PriceModifierProduct> priceModifierProducts = new ArrayList<PriceModifierProduct>();
        for (CommercePriceModifierRel commercePriceModifierRel : commercePriceModifierRels) {
            priceModifierProducts.add(this._toPriceModifierProduct(commercePriceModifierRel.getCommercePriceModifierRelId()));
        }
        return priceModifierProducts;
    }
}

