/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.pricing.exception.NoSuchPriceModifierException;
import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.model.CommercePriceModifierRel;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.CommercePriceModifierRelService;
import com.liferay.commerce.pricing.service.CommercePriceModifierService;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceModifierProductGroup;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceModifierProductGroupDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceModifierProductGroupResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceModifierProductGroupUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceModifierProductGroupResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/price-modifier-product-group.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceModifierProductGroupResource.class})
public class PriceModifierProductGroupResourceImpl
extends BasePriceModifierProductGroupResourceImpl {
    @Reference
    private CommercePriceModifierRelService _commercePriceModifierRelService;
    @Reference
    private CommercePriceModifierService _commercePriceModifierService;
    @Reference
    private CommercePricingClassService _commercePricingClassService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceModifierProductGroupDTOConverter _priceModifierProductGroupDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceModifierProductGroup(Long id) throws Exception {
        this._commercePriceModifierRelService.deleteCommercePriceModifierRel(id.longValue());
    }

    @Override
    public Page<PriceModifierProductGroup> getPriceModifierByExternalReferenceCodePriceModifierProductGroupsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find Price Modifier with externalReferenceCode: " + externalReferenceCode);
        }
        List commercePriceModifierRels = this._commercePriceModifierRelService.getCommercePriceModifierRels(commercePriceModifier.getCommercePriceModifierId(), CommercePricingClass.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceModifierRelService.getCommercePriceModifierRelsCount(commercePriceModifier.getCommercePriceModifierId(), CommercePricingClass.class.getName());
        return Page.of(this._toPriceModifierProductGroups(commercePriceModifierRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<PriceModifierProductGroup> getPriceModifierIdPriceModifierProductGroupsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commercePriceModifierRels = this._commercePriceModifierRelService.getCommercePricingClassesCommercePriceModifierRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commercePriceModifierRelService.getCommercePricingClassesCommercePriceModifierRelsCount(id.longValue(), search);
        return Page.of(this._toPriceModifierProductGroups(commercePriceModifierRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public PriceModifierProductGroup postPriceModifierByExternalReferenceCodePriceModifierProductGroup(String externalReferenceCode, PriceModifierProductGroup priceModifierProductGroup) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find Price Modifier with externalReferenceCode: " + externalReferenceCode);
        }
        CommercePriceModifierRel commercePriceModifierRel = PriceModifierProductGroupUtil.addCommercePriceModifierRel(this._commercePricingClassService, this._commercePriceModifierRelService, priceModifierProductGroup, commercePriceModifier, this._serviceContextHelper);
        return this._toPriceModifierProductGroup(commercePriceModifierRel.getCommercePriceModifierRelId());
    }

    @Override
    public PriceModifierProductGroup postPriceModifierIdPriceModifierProductGroup(Long id, PriceModifierProductGroup priceModifierProductGroup) throws Exception {
        CommercePriceModifierRel commercePriceModifierRel = PriceModifierProductGroupUtil.addCommercePriceModifierRel(this._commercePricingClassService, this._commercePriceModifierRelService, priceModifierProductGroup, this._commercePriceModifierService.getCommercePriceModifier(id.longValue()), this._serviceContextHelper);
        return this._toPriceModifierProductGroup(commercePriceModifierRel.getCommercePriceModifierRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceModifierRel commercePriceModifierRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", () -> {
            CommercePriceModifier commercePriceModifier = commercePriceModifierRel.getCommercePriceModifier();
            return this.addAction("UPDATE", commercePriceModifier.getCommercePriceListId(), "deletePriceModifierProductGroup", commercePriceModifier.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceModifier.getGroupId());
        }).build();
    }

    private PriceModifierProductGroup _toPriceModifierProductGroup(Long commercePriceModifierRelId) throws Exception {
        CommercePriceModifierRel commercePriceModifierRel = this._commercePriceModifierRelService.getCommercePriceModifierRel(commercePriceModifierRelId.longValue());
        return this._priceModifierProductGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceModifierRel), this._dtoConverterRegistry, (Object)commercePriceModifierRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<PriceModifierProductGroup> _toPriceModifierProductGroups(List<CommercePriceModifierRel> commercePriceModifierRels) throws Exception {
        ArrayList<PriceModifierProductGroup> priceModifierProductGroups = new ArrayList<PriceModifierProductGroup>();
        for (CommercePriceModifierRel commercePriceModifierRel : commercePriceModifierRels) {
            priceModifierProductGroups.add(this._toPriceModifierProductGroup(commercePriceModifierRel.getCommercePriceModifierRelId()));
        }
        return priceModifierProductGroups;
    }
}

