/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListChannelRel;
import com.liferay.commerce.price.list.service.CommercePriceListChannelRelService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceListChannel;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceListChannelDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceListChannelResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceListChannelUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceListChannelResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/price-list-channel.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceListChannelResource.class})
public class PriceListChannelResourceImpl
extends BasePriceListChannelResourceImpl {
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommercePriceListChannelRelService _commercePriceListChannelRelService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceListChannelDTOConverter _priceListChannelDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceListChannel(Long id) throws Exception {
        this._commercePriceListChannelRelService.deleteCommercePriceListChannelRel(id.longValue());
    }

    @Override
    public Page<PriceListChannel> getPriceListByExternalReferenceCodePriceListChannelsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        List commercePriceListChannelRels = this._commercePriceListChannelRelService.getCommercePriceListChannelRels(commercePriceList.getCommercePriceListId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceListChannelRelService.getCommercePriceListChannelRelsCount(commercePriceList.getCommercePriceListId());
        return Page.of(this._toPriceListChannels(commercePriceListChannelRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<PriceListChannel> getPriceListIdPriceListChannelsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commercePriceListChannelRels = this._commercePriceListChannelRelService.getCommercePriceListChannelRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commercePriceListChannelRelService.getCommercePriceListChannelRelsCount(id.longValue(), search);
        return Page.of(this._toPriceListChannels(commercePriceListChannelRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public PriceListChannel postPriceListByExternalReferenceCodePriceListChannel(String externalReferenceCode, PriceListChannel priceListChannel) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        CommercePriceListChannelRel commercePriceListChannelRel = PriceListChannelUtil.addCommercePriceListChannelRel(this._commerceChannelService, this._commercePriceListChannelRelService, priceListChannel, commercePriceList, this._serviceContextHelper);
        return this._toPriceListChannel(commercePriceListChannelRel.getCommercePriceListChannelRelId());
    }

    @Override
    public PriceListChannel postPriceListIdPriceListChannel(Long id, PriceListChannel priceListChannel) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.getCommercePriceList(id.longValue());
        CommercePriceListChannelRel commercePriceListChannelRel = PriceListChannelUtil.addCommercePriceListChannelRel(this._commerceChannelService, this._commercePriceListChannelRelService, priceListChannel, commercePriceList, this._serviceContextHelper);
        return this._toPriceListChannel(commercePriceListChannelRel.getCommercePriceListChannelRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceListChannelRel commercePriceListChannelRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", () -> {
            CommercePriceList commercePriceList = commercePriceListChannelRel.getCommercePriceList();
            return this.addAction("UPDATE", commercePriceList.getCommercePriceListId(), "deletePriceListChannel", commercePriceList.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceList.getGroupId());
        }).build();
    }

    private PriceListChannel _toPriceListChannel(Long commercePriceListChannelRelId) throws Exception {
        CommercePriceListChannelRel commercePriceListChannelRel = this._commercePriceListChannelRelService.getCommercePriceListChannelRel(commercePriceListChannelRelId.longValue());
        return this._priceListChannelDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceListChannelRel), this._dtoConverterRegistry, (Object)commercePriceListChannelRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<PriceListChannel> _toPriceListChannels(List<CommercePriceListChannelRel> commercePriceListChannelRels) throws Exception {
        ArrayList<PriceListChannel> priceListChannels = new ArrayList<PriceListChannel>();
        for (CommercePriceListChannelRel commercePriceListChannelRel : commercePriceListChannelRels) {
            priceListChannels.add(this._toPriceListChannel(commercePriceListChannelRel.getCommercePriceListChannelRelId()));
        }
        return priceListChannels;
    }
}

