/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountAccountRel;
import com.liferay.commerce.discount.model.CommerceDiscountCommerceAccountGroupRel;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.service.CommerceDiscountAccountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountCommerceAccountGroupRelService;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountRuleService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.commerce.product.exception.NoSuchCProductException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Discount;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountAccount;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountAccountGroup;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountCategory;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountChannel;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountProduct;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountProductGroup;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountRule;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.odata.entity.v2_0.DiscountEntityModel;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountAccountGroupUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountAccountUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountCategoryUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountChannelUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountProductGroupUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountProductUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountRuleUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/discount.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountResource.class})
public class DiscountResourceImpl
extends BaseDiscountResourceImpl {
    private static final EntityModel _entityModel = new DiscountEntityModel();
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceDiscountAccountRelService _commerceDiscountAccountRelService;
    @Reference
    private CommerceDiscountCommerceAccountGroupRelService _commerceDiscountCommerceAccountGroupRelService;
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommerceDiscountRuleService _commerceDiscountRuleService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CommercePricingClassService _commercePricingClassService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private DiscountDTOConverter _discountDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscount(Long id) throws Exception {
        this._commerceDiscountService.deleteCommerceDiscount(id.longValue());
    }

    @Override
    public void deleteDiscountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceDiscountService.deleteCommerceDiscount(commerceDiscount.getCommerceDiscountId());
    }

    @Override
    public Discount getDiscount(Long id) throws Exception {
        return this._toDiscount(GetterUtil.getLong((Object)id));
    }

    @Override
    public Discount getDiscountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toDiscount(commerceDiscount.getCommerceDiscountId());
    }

    @Override
    public Page<Discount> getDiscountsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CommerceDiscount.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setAttribute("skipCommerceAccountGroupValidation", (Serializable)Boolean.TRUE);
                searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
                searchContext.setCompanyId(DiscountResourceImpl.this.contextCompany.getCompanyId());
            }
        }, (Sort[])sorts, document -> this._toDiscount(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Discount patchDiscount(Long id, Discount discount) throws Exception {
        return this._toDiscount(this._updateDiscount(this._commerceDiscountService.getCommerceDiscount(id.longValue()), discount));
    }

    @Override
    public Discount patchDiscountByExternalReferenceCode(String externalReferenceCode, Discount discount) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toDiscount(this._updateDiscount(commerceDiscount, discount));
    }

    @Override
    public Discount postDiscount(Discount discount) throws Exception {
        CommerceDiscount commerceDiscount = this._upsertCommerceDiscount(discount);
        return this._toDiscount(commerceDiscount.getCommerceDiscountId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceDiscount commerceDiscount) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceDiscount.getCommerceDiscountId(), "deleteDiscount", commerceDiscount.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId())).put((Object)"get", this.addAction("VIEW", commerceDiscount.getCommerceDiscountId(), "getDiscount", commerceDiscount.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId())).put((Object)"permissions", this.addAction("PERMISSIONS", commerceDiscount.getCommerceDiscountId(), "patchDiscount", commerceDiscount.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId())).put((Object)"update", this.addAction("UPDATE", commerceDiscount.getCommerceDiscountId(), "patchDiscount", commerceDiscount.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId())).build();
    }

    private DateConfig _getDisplayDateConfig(Date date, TimeZone timeZone) {
        if (date == null) {
            return new DateConfig(CalendarFactoryUtil.getCalendar((TimeZone)timeZone));
        }
        long time = date.getTime();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)time, (TimeZone)timeZone);
        return new DateConfig(calendar);
    }

    private DateConfig _getExpirationDateConfig(Date date, TimeZone timeZone) {
        if (date == null) {
            Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
            expirationCalendar.add(2, 1);
            return new DateConfig(expirationCalendar);
        }
        long time = date.getTime();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)time, (TimeZone)timeZone);
        return new DateConfig(calendar);
    }

    private Discount _toDiscount(CommerceDiscount commerceDiscount) throws Exception {
        return this._toDiscount(commerceDiscount.getCommerceDiscountId());
    }

    private Discount _toDiscount(Long commerceDiscountId) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.getCommerceDiscount(commerceDiscountId.longValue());
        return this._discountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceDiscount), this._dtoConverterRegistry, (Object)commerceDiscountId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private CommerceDiscount _updateDiscount(CommerceDiscount commerceDiscount, Discount discount) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = this._getDisplayDateConfig(discount.getDisplayDate(), serviceContext.getTimeZone());
        DateConfig expirationDateConfig = this._getExpirationDateConfig(discount.getExpirationDate(), serviceContext.getTimeZone());
        commerceDiscount = this._commerceDiscountService.updateCommerceDiscount(commerceDiscount.getCommerceDiscountId(), discount.getTitle(), discount.getTarget(), GetterUtil.get((Object)discount.getUseCouponCode(), (boolean)commerceDiscount.isUseCouponCode()), GetterUtil.get((String)discount.getCouponCode(), (String)commerceDiscount.getCouponCode()), GetterUtil.get((Object)discount.getUsePercentage(), (boolean)commerceDiscount.isUsePercentage()), (BigDecimal)GetterUtil.get((Object)discount.getMaximumDiscountAmount(), (Number)commerceDiscount.getMaximumDiscountAmount()), GetterUtil.get((String)discount.getLevel(), (String)commerceDiscount.getLevel()), (BigDecimal)GetterUtil.get((Object)discount.getPercentageLevel1(), (Number)commerceDiscount.getLevel1()), (BigDecimal)GetterUtil.get((Object)discount.getPercentageLevel2(), (Number)commerceDiscount.getLevel2()), (BigDecimal)GetterUtil.get((Object)discount.getPercentageLevel3(), (Number)commerceDiscount.getLevel3()), (BigDecimal)GetterUtil.get((Object)discount.getPercentageLevel4(), (Number)commerceDiscount.getLevel4()), discount.getLimitationType(), GetterUtil.get((Object)discount.getLimitationTimes(), (int)commerceDiscount.getLimitationTimes()), GetterUtil.get((Object)discount.getLimitationTimesPerAccount(), (int)commerceDiscount.getLimitationTimesPerAccount()), GetterUtil.get((Object)discount.getRulesConjunction(), (boolean)commerceDiscount.isRulesConjunction()), GetterUtil.get((Object)discount.getActive(), (boolean)commerceDiscount.isActive()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)discount.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = discount.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommerceDiscount.class, (long)commerceDiscount.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(discount, commerceDiscount);
    }

    private CommerceDiscount _updateNestedResources(Discount discount, CommerceDiscount commerceDiscount) throws Exception {
        DiscountRule[] discountRules;
        DiscountProduct[] discountProducts;
        DiscountProductGroup[] discountProductGroups;
        DiscountChannel[] discountChannels;
        DiscountCategory[] discountCategories;
        DiscountAccount[] discountAccounts;
        DiscountAccountGroup[] discountAccountGroups = discount.getDiscountAccountGroups();
        if (discountAccountGroups != null) {
            for (DiscountAccountGroup discountAccountGroup : discountAccountGroups) {
                CommerceDiscountCommerceAccountGroupRel commerceDiscountCommerceAccountGroupRel = this._commerceDiscountCommerceAccountGroupRelService.fetchCommerceDiscountCommerceAccountGroupRel(commerceDiscount.getCommerceDiscountId(), discountAccountGroup.getAccountGroupId().longValue());
                if (commerceDiscountCommerceAccountGroupRel != null) continue;
                DiscountAccountGroupUtil.addCommerceDiscountCommerceAccountGroupRel(this._commerceAccountGroupService, this._commerceDiscountCommerceAccountGroupRelService, discountAccountGroup, commerceDiscount, this._serviceContextHelper);
            }
        }
        if ((discountAccounts = discount.getDiscountAccounts()) != null) {
            for (DiscountAccount discountAccount : discountAccounts) {
                CommerceDiscountAccountRel commerceDiscountAccountRel = this._commerceDiscountAccountRelService.fetchCommerceDiscountAccountRel(commerceDiscount.getCommerceDiscountId(), discountAccount.getAccountId().longValue());
                if (commerceDiscountAccountRel != null) continue;
                DiscountAccountUtil.addCommerceDiscountAccountRel(this._commerceAccountService, this._commerceDiscountAccountRelService, discountAccount, commerceDiscount, this._serviceContextHelper);
            }
        }
        if ((discountCategories = discount.getDiscountCategories()) != null) {
            for (DiscountCategory discountCategory : discountCategories) {
                CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.fetchCommerceDiscountRel(AssetCategory.class.getName(), discountCategory.getCategoryId().longValue());
                if (commerceDiscountRel != null) continue;
                DiscountCategoryUtil.addCommerceDiscountRel(this._assetCategoryLocalService, this._commerceDiscountRelService, discountCategory, commerceDiscount, this._serviceContextHelper);
            }
        }
        if ((discountChannels = discount.getDiscountChannels()) != null) {
            for (DiscountChannel discountChannel : discountChannels) {
                CommerceChannelRel commerceChannelRel = this._commerceChannelRelService.fetchCommerceChannelRel(CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId(), discountChannel.getChannelId().longValue());
                if (commerceChannelRel != null) continue;
                DiscountChannelUtil.addCommerceDiscountChannelRel(this._commerceChannelService, this._commerceChannelRelService, discountChannel, commerceDiscount, this._serviceContextHelper);
            }
        }
        if ((discountProductGroups = discount.getDiscountProductGroups()) != null) {
            for (DiscountProductGroup discountProductGroup : discountProductGroups) {
                CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.fetchCommerceDiscountRel(DiscountProductGroup.class.getName(), discountProductGroup.getProductGroupId().longValue());
                if (commerceDiscountRel != null) continue;
                DiscountProductGroupUtil.addCommerceDiscountRel(this._commercePricingClassService, this._commerceDiscountRelService, discountProductGroup, commerceDiscount, this._serviceContextHelper);
            }
        }
        if ((discountProducts = discount.getDiscountProducts()) != null) {
            for (DiscountProduct discountProduct : discountProducts) {
                CProduct cProduct = this._cProductLocalService.fetchCProduct(discountProduct.getProductId().longValue());
                if (cProduct == null) {
                    cProduct = this._cProductLocalService.fetchCProductByReferenceCode(this.contextCompany.getCompanyId(), discountProduct.getProductExternalReferenceCode());
                }
                if (cProduct == null) {
                    throw new NoSuchCProductException("Unable to find Product with externalReferenceCode: " + discountProduct.getProductExternalReferenceCode());
                }
                CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.fetchCommerceDiscountRel(CPDefinition.class.getName(), cProduct.getPublishedCPDefinitionId());
                if (commerceDiscountRel != null) continue;
                DiscountProductUtil.addCommerceDiscountRel(this._cProductLocalService, this._commerceDiscountRelService, discountProduct, commerceDiscount, this._serviceContextHelper);
            }
        }
        if ((discountRules = discount.getDiscountRules()) != null) {
            for (DiscountRule discountRule : discountRules) {
                CommerceDiscountRule commerceDiscountRule = this._commerceDiscountRuleService.fetchCommerceDiscountRule(discountRule.getId().longValue());
                if (commerceDiscountRule != null) continue;
                DiscountRuleUtil.addCommerceDiscountRule(this._commerceDiscountRuleService, discountRule, commerceDiscount, this._serviceContextHelper);
            }
        }
        return commerceDiscount;
    }

    private CommerceDiscount _upsertCommerceDiscount(Discount discount) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = this._getDisplayDateConfig(discount.getDisplayDate(), serviceContext.getTimeZone());
        DateConfig expirationDateConfig = this._getExpirationDateConfig(discount.getExpirationDate(), serviceContext.getTimeZone());
        CommerceDiscount commerceDiscount = this._commerceDiscountService.upsertCommerceDiscount(this.contextUser.getUserId(), GetterUtil.getLong((Object)discount.getId()), discount.getTitle(), discount.getTarget(), GetterUtil.getBoolean((Object)discount.getUseCouponCode()), discount.getCouponCode(), GetterUtil.getBoolean((Object)discount.getUsePercentage()), discount.getMaximumDiscountAmount(), discount.getLevel(), discount.getPercentageLevel1(), discount.getPercentageLevel2(), discount.getPercentageLevel3(), discount.getPercentageLevel4(), discount.getLimitationType(), GetterUtil.getInteger((Object)discount.getLimitationTimes()), GetterUtil.getInteger((Object)discount.getLimitationTimesPerAccount()), GetterUtil.getBoolean((Object)discount.getRulesConjunction()), GetterUtil.getBoolean((Object)discount.getActive()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), discount.getExternalReferenceCode(), GetterUtil.getBoolean((Object)discount.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = discount.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommerceDiscount.class, (long)commerceDiscount.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(discount, commerceDiscount);
    }
}

