/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0;

import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyService;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListCommerceAccountGroupRel;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListCommerceAccountGroupRelService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryService;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.PriceEntry;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.PriceList;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.PriceListAccountGroup;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.TierPrice;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter.PriceListDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.odata.entity.v1_0.PriceListEntityModel;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0.BasePriceListResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.PriceListAccountGroupUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.TierPriceUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v1_0.PriceListResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/price-list.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceListResource.class})
public class PriceListResourceImpl
extends BasePriceListResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new PriceListEntityModel();
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference
    private CommerceCurrencyService _commerceCurrencyService;
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceListCommerceAccountGroupRelService _commercePriceListCommerceAccountGroupRelService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommerceTierPriceEntryService _commerceTierPriceEntryService;
    @Reference
    private PriceListDTOConverter _priceListDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deletePriceList(Long id) throws Exception {
        this._commercePriceListService.deleteCommercePriceList(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deletePriceListByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        this._commercePriceListService.deleteCommercePriceList(commercePriceList.getCommercePriceListId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public PriceList getPriceList(Long id) throws Exception {
        return this._toPriceList(GetterUtil.getLong((Object)id));
    }

    @Override
    public PriceList getPriceListByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toPriceList(commercePriceList.getCommercePriceListId());
    }

    @Override
    public Page<PriceList> getPriceListsPage(Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CommercePriceList.class, (String)"", (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setCompanyId(PriceListResourceImpl.this.contextCompany.getCompanyId());
            }
        }, document -> this._toPriceList(GetterUtil.getLong((String)document.get("entryClassPK"))), (Sort[])sorts);
    }

    @Override
    public Response patchPriceList(Long id, PriceList priceList) throws Exception {
        this._updatePriceList(this._commercePriceListService.getCommercePriceList(id.longValue()), priceList);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchPriceListByExternalReferenceCode(String externalReferenceCode, PriceList priceList) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        this._updatePriceList(commercePriceList, priceList);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public PriceList postPriceList(PriceList priceList) throws Exception {
        CommercePriceList commercePriceList = this._upsertPriceList(priceList);
        return this._toPriceList(commercePriceList.getCommercePriceListId());
    }

    private PriceList _toPriceList(Long commercePriceListId) throws Exception {
        return this._priceListDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commercePriceListId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private CommercePriceList _updateNestedResources(PriceList priceList, CommercePriceList commercePriceList, ServiceContext serviceContext) throws Exception {
        PriceEntry[] priceEntries;
        PriceListAccountGroup[] priceListAccountGroups = priceList.getPriceListAccountGroups();
        if (priceListAccountGroups != null) {
            for (PriceListAccountGroup priceListAccountGroup : priceListAccountGroups) {
                CommercePriceListCommerceAccountGroupRel commercePriceListCommerceAccountGroupRel = this._commercePriceListCommerceAccountGroupRelService.fetchCommercePriceListCommerceAccountGroupRel(commercePriceList.getCommercePriceListId(), priceListAccountGroup.getAccountGroupId().longValue());
                if (commercePriceListCommerceAccountGroupRel != null) continue;
                PriceListAccountGroupUtil.addCommercePriceListCommerceAccountGroupRel(this._commerceAccountGroupService, this._commercePriceListCommerceAccountGroupRelService, priceListAccountGroup, commercePriceList, serviceContext);
            }
        }
        if ((priceEntries = priceList.getPriceEntries()) != null) {
            for (PriceEntry priceEntry : priceEntries) {
                CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.upsertCommercePriceEntry(GetterUtil.getLong((Object)priceEntry.getId()), GetterUtil.getLong((Object)priceEntry.getSkuId()), null, commercePriceList.getCommercePriceListId(), priceEntry.getExternalReferenceCode(), priceEntry.getPrice(), (BigDecimal)GetterUtil.get((Object)priceEntry.getPromoPrice(), (Number)BigDecimal.ZERO), priceEntry.getSkuExternalReferenceCode(), serviceContext);
                TierPrice[] tierPrices = priceEntry.getTierPrices();
                if (tierPrices == null) continue;
                for (TierPrice tierPrice : tierPrices) {
                    TierPriceUtil.upsertCommerceTierPriceEntry(this._commerceTierPriceEntryService, tierPrice, commercePriceEntry, serviceContext);
                }
            }
        }
        return commercePriceList;
    }

    private CommercePriceList _updatePriceList(CommercePriceList commercePriceList, PriceList priceList) throws Exception {
        CommerceCurrency commerceCurrency = this._commerceCurrencyService.getCommerceCurrency(this.contextCompany.getCompanyId(), priceList.getCurrencyCode());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commercePriceList.getGroupId());
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        commercePriceList = this._commercePriceListService.updateCommercePriceList(commercePriceList.getCommercePriceListId(), commerceCurrency.getCommerceCurrencyId(), GetterUtil.get((String)priceList.getName(), (String)commercePriceList.getName()), GetterUtil.get((Object)priceList.getPriority(), (double)commercePriceList.getPriority()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)priceList.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = priceList.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommercePriceList.class, (long)commercePriceList.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(priceList, commercePriceList, serviceContext);
    }

    private CommercePriceList _upsertPriceList(PriceList priceList) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.getCommerceCatalog(priceList.getCatalogId().longValue());
        CommerceCurrency commerceCurrency = this._commerceCurrencyService.getCommerceCurrency(this.contextCompany.getCompanyId(), priceList.getCurrencyCode());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        CommercePriceList commercePriceList = this._commercePriceListService.upsertCommercePriceList(commerceCatalog.getGroupId(), this.contextUser.getUserId(), 0L, commerceCurrency.getCommerceCurrencyId(), priceList.getName(), GetterUtil.get((Object)priceList.getPriority(), (double)0.0), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), priceList.getExternalReferenceCode(), GetterUtil.getBoolean((Object)priceList.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = priceList.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommercePriceList.class, (long)commercePriceList.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(priceList, commercePriceList, serviceContext);
    }
}

