/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0;

import com.liferay.commerce.price.list.exception.NoSuchPriceEntryException;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.PriceEntry;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.TierPrice;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter.PriceEntryDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0.BasePriceEntryResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.TierPriceUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v1_0.PriceEntryResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/price-entry.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceEntryResource.class})
public class PriceEntryResourceImpl
extends BasePriceEntryResourceImpl {
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommerceTierPriceEntryService _commerceTierPriceEntryService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private PriceEntryDTOConverter _priceEntryDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deletePriceEntry(Long id) throws Exception {
        this._commercePriceEntryService.deleteCommercePriceEntry(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deletePriceEntryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find Price Entry with externalReferenceCode: " + externalReferenceCode);
        }
        this._commercePriceEntryService.deleteCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public PriceEntry getPriceEntry(Long id) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getCommercePriceEntry(id.longValue());
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public PriceEntry getPriceEntryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find Price Entry with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public Page<PriceEntry> getPriceListByExternalReferenceCodePriceEntriesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        List commercePriceEntries = this._commercePriceEntryService.getCommercePriceEntries(commercePriceList.getCommercePriceListId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commercePriceEntryService.getCommercePriceEntriesCount(commercePriceList.getCommercePriceListId());
        return Page.of(this._toPriceEntries(commercePriceEntries), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<PriceEntry> getPriceListIdPriceEntriesPage(Long id, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchCommercePriceList(id.longValue());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with id: " + id);
        }
        List commercePriceEntries = this._commercePriceEntryService.getCommercePriceEntries(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commercePriceEntryService.getCommercePriceEntriesCount(id.longValue());
        return Page.of(this._toPriceEntries(commercePriceEntries), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Response patchPriceEntry(Long id, PriceEntry priceEntry) throws Exception {
        this._updatePriceEntry(this._commercePriceEntryService.getCommercePriceEntry(id.longValue()), priceEntry);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchPriceEntryByExternalReferenceCode(String externalReferenceCode, PriceEntry priceEntry) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find Price Entry with externalReferenceCode: " + externalReferenceCode);
        }
        this._updatePriceEntry(commercePriceEntry, priceEntry);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public PriceEntry postPriceListByExternalReferenceCodePriceEntry(String externalReferenceCode, PriceEntry priceEntry) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        CommercePriceEntry commercePriceEntry = this._upsertCommercePriceEntry(commercePriceList, priceEntry);
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public PriceEntry postPriceListIdPriceEntry(Long id, PriceEntry priceEntry) throws Exception {
        CommercePriceEntry commercePriceEntry = this._upsertCommercePriceEntry(this._commercePriceListService.getCommercePriceList(id.longValue()), priceEntry);
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    private List<PriceEntry> _toPriceEntries(List<CommercePriceEntry> commercePriceEntries) throws Exception {
        ArrayList<PriceEntry> priceEntries = new ArrayList<PriceEntry>();
        for (CommercePriceEntry commercePriceEntry : commercePriceEntries) {
            priceEntries.add(this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId()));
        }
        return priceEntries;
    }

    private PriceEntry _toPriceEntry(Long commercePriceEntryId) throws Exception {
        return this._priceEntryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commercePriceEntryId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private void _updateNestedResources(PriceEntry priceEntry, CommercePriceEntry commercePriceEntry, ServiceContext serviceContext) throws Exception {
        TierPrice[] tierPrices = priceEntry.getTierPrices();
        if (tierPrices != null) {
            for (TierPrice tierPrice : tierPrices) {
                TierPriceUtil.upsertCommerceTierPriceEntry(this._commerceTierPriceEntryService, tierPrice, commercePriceEntry, serviceContext);
            }
        }
    }

    private CommercePriceEntry _updatePriceEntry(CommercePriceEntry commercePriceEntry, PriceEntry priceEntry) throws Exception {
        commercePriceEntry = this._commercePriceEntryService.updateCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId(), priceEntry.getPrice(), priceEntry.getPromoPrice(), this._serviceContextHelper.getServiceContext());
        this._updateNestedResources(priceEntry, commercePriceEntry, this._serviceContextHelper.getServiceContext());
        return commercePriceEntry;
    }

    private CommercePriceEntry _upsertCommercePriceEntry(CommercePriceList commercePriceList, PriceEntry priceEntry) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commercePriceList.getGroupId());
        long cProductId = 0L;
        String cpInstanceUuid = null;
        CPInstance cpInstance = null;
        long skuId = GetterUtil.getLong((Object)priceEntry.getSkuId());
        String skuExternalReferenceCode = priceEntry.getSkuExternalReferenceCode();
        if (skuId > 0L) {
            cpInstance = this._cpInstanceService.fetchCPInstance(skuId);
        } else if (Validator.isNotNull((String)skuExternalReferenceCode)) {
            cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), skuExternalReferenceCode);
        }
        if (cpInstance != null) {
            CPDefinition cpDefinition = cpInstance.getCPDefinition();
            cProductId = cpDefinition.getCProductId();
            cpInstanceUuid = cpInstance.getCPInstanceUuid();
        }
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.upsertCommercePriceEntry(GetterUtil.getLong((Object)priceEntry.getId()), cProductId, cpInstanceUuid, commercePriceList.getCommercePriceListId(), priceEntry.getExternalReferenceCode(), priceEntry.getPrice(), (BigDecimal)GetterUtil.get((Object)priceEntry.getPromoPrice(), (Number)BigDecimal.ZERO), priceEntry.getSkuExternalReferenceCode(), serviceContext);
        this._updateNestedResources(priceEntry, commercePriceEntry, serviceContext);
        return commercePriceEntry;
    }
}

