/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountCommerceAccountGroupRel;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.service.CommerceDiscountCommerceAccountGroupRelService;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountRuleService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.product.exception.NoSuchCProductException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.Discount;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.DiscountAccountGroup;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.DiscountCategory;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.DiscountProduct;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.DiscountRule;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter.DiscountDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0.BaseDiscountResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.DiscountAccountGroupUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.DiscountCategoryUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.DiscountProductUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.DiscountRuleUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v1_0.DiscountResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/discount.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountResource.class})
public class DiscountResourceImpl
extends BaseDiscountResourceImpl {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private CommerceDiscountCommerceAccountGroupRelService _commerceDiscountCommerceAccountGroupRelService;
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommerceDiscountRuleService _commerceDiscountRuleService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private DiscountDTOConverter _discountDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteDiscount(Long id) throws Exception {
        this._commerceDiscountService.deleteCommerceDiscount(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteDiscountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        this._commerceDiscountService.deleteCommerceDiscount(commerceDiscount.getCommerceDiscountId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Discount getDiscount(Long id) throws Exception {
        return this._toDiscount(GetterUtil.getLong((Object)id));
    }

    @Override
    public Discount getDiscountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toDiscount(commerceDiscount.getCommerceDiscountId());
    }

    @Override
    public Page<Discount> getDiscountsPage(Pagination pagination) throws Exception {
        BaseModelSearchResult commerceDiscountBaseModelSearchResult = this._commerceDiscountService.searchCommerceDiscounts(this.contextCompany.getCompanyId(), "", 0, pagination.getStartPosition(), pagination.getEndPosition(), null);
        return Page.of(this._toDiscounts(commerceDiscountBaseModelSearchResult.getBaseModels()), (Pagination)pagination, (long)commerceDiscountBaseModelSearchResult.getLength());
    }

    @Override
    public Response patchDiscount(Long id, Discount discount) throws Exception {
        this._updateDiscount(this._commerceDiscountService.getCommerceDiscount(id.longValue()), discount);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchDiscountByExternalReferenceCode(String externalReferenceCode, Discount discount) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateDiscount(commerceDiscount, discount);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Discount postDiscount(Discount discount) throws Exception {
        CommerceDiscount commerceDiscount = this._upsertCommerceDiscount(discount);
        return this._toDiscount(commerceDiscount.getCommerceDiscountId());
    }

    private Discount _toDiscount(Long commerceDiscountId) throws Exception {
        return this._discountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceDiscountId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<Discount> _toDiscounts(List<CommerceDiscount> commerceDiscounts) throws Exception {
        ArrayList<Discount> discounts = new ArrayList<Discount>();
        for (CommerceDiscount commerceDiscount : commerceDiscounts) {
            discounts.add(this._toDiscount(commerceDiscount.getCommerceDiscountId()));
        }
        return discounts;
    }

    private CommerceDiscount _updateDiscount(CommerceDiscount commerceDiscount, Discount discount) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        commerceDiscount = this._commerceDiscountService.updateCommerceDiscount(commerceDiscount.getCommerceDiscountId(), discount.getTitle(), discount.getTarget(), GetterUtil.get((Object)discount.getUseCouponCode(), (boolean)commerceDiscount.isUseCouponCode()), GetterUtil.get((String)discount.getCouponCode(), (String)commerceDiscount.getCouponCode()), GetterUtil.get((Object)discount.getUsePercentage(), (boolean)commerceDiscount.isUsePercentage()), (BigDecimal)GetterUtil.get((Object)discount.getMaximumDiscountAmount(), (Number)commerceDiscount.getMaximumDiscountAmount()), (BigDecimal)GetterUtil.get((Object)discount.getPercentageLevel1(), (Number)commerceDiscount.getLevel1()), (BigDecimal)GetterUtil.get((Object)discount.getPercentageLevel2(), (Number)commerceDiscount.getLevel2()), (BigDecimal)GetterUtil.get((Object)discount.getPercentageLevel3(), (Number)commerceDiscount.getLevel3()), (BigDecimal)GetterUtil.get((Object)discount.getPercentageLevel4(), (Number)commerceDiscount.getLevel4()), discount.getLimitationType(), GetterUtil.get((Object)discount.getLimitationTimes(), (int)commerceDiscount.getLimitationTimes()), GetterUtil.get((Object)discount.getActive(), (boolean)commerceDiscount.isActive()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)discount.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = discount.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommerceDiscount.class, (long)commerceDiscount.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(discount, commerceDiscount, serviceContext);
    }

    private CommerceDiscount _updateNestedResources(Discount discount, CommerceDiscount commerceDiscount, ServiceContext serviceContext) throws Exception {
        DiscountRule[] discountRules;
        DiscountProduct[] discountProducts;
        DiscountCategory[] discountCategories;
        DiscountAccountGroup[] discountAccountGroups = discount.getDiscountAccountGroups();
        if (discountAccountGroups != null) {
            for (DiscountAccountGroup discountAccountGroup : discountAccountGroups) {
                CommerceDiscountCommerceAccountGroupRel commerceDiscountCommerceAccountGroupRel = this._commerceDiscountCommerceAccountGroupRelService.fetchCommerceDiscountCommerceAccountGroupRel(commerceDiscount.getCommerceDiscountId(), discountAccountGroup.getAccountGroupId().longValue());
                if (commerceDiscountCommerceAccountGroupRel != null) continue;
                DiscountAccountGroupUtil.addCommerceDiscountCommerceAccountGroupRel(this._commerceAccountGroupService, this._commerceDiscountCommerceAccountGroupRelService, discountAccountGroup, commerceDiscount, serviceContext);
            }
        }
        if ((discountCategories = discount.getDiscountCategories()) != null) {
            for (DiscountCategory discountCategory : discountCategories) {
                CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.fetchCommerceDiscountRel(AssetCategory.class.getName(), discountCategory.getCategoryId().longValue());
                if (commerceDiscountRel != null) continue;
                DiscountCategoryUtil.addCommerceDiscountRel(this._assetCategoryLocalService, this._commerceDiscountRelService, discountCategory, commerceDiscount, serviceContext);
            }
        }
        if ((discountProducts = discount.getDiscountProducts()) != null) {
            for (DiscountProduct discountProduct : discountProducts) {
                CProduct cProduct = this._cProductLocalService.fetchCProduct(discountProduct.getProductId().longValue());
                if (cProduct == null) {
                    cProduct = this._cProductLocalService.fetchCProductByReferenceCode(this.contextCompany.getCompanyId(), discountProduct.getProductExternalReferenceCode());
                }
                if (cProduct == null) {
                    throw new NoSuchCProductException("Unable to find Product with externalReferenceCode: " + discountProduct.getProductExternalReferenceCode());
                }
                CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.fetchCommerceDiscountRel(CPDefinition.class.getName(), cProduct.getPublishedCPDefinitionId());
                if (commerceDiscountRel != null) continue;
                DiscountProductUtil.addCommerceDiscountRel(this._cProductLocalService, this._commerceDiscountRelService, discountProduct, commerceDiscount, serviceContext);
            }
        }
        if ((discountRules = discount.getDiscountRules()) != null) {
            for (DiscountRule discountRule : discountRules) {
                CommerceDiscountRule commerceDiscountRule = this._commerceDiscountRuleService.fetchCommerceDiscountRule(discountRule.getId().longValue());
                if (commerceDiscountRule != null) continue;
                DiscountRuleUtil.addCommerceDiscountRule(this._commerceDiscountRuleService, discountRule, commerceDiscount, serviceContext);
            }
        }
        return commerceDiscount;
    }

    private CommerceDiscount _upsertCommerceDiscount(Discount discount) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        CommerceDiscount commerceDiscount = this._commerceDiscountService.upsertCommerceDiscount(this.contextUser.getUserId(), GetterUtil.getLong((Object)discount.getId()), discount.getTitle(), discount.getTarget(), GetterUtil.getBoolean((Object)discount.getUseCouponCode()), discount.getCouponCode(), GetterUtil.getBoolean((Object)discount.getUsePercentage()), discount.getMaximumDiscountAmount(), discount.getPercentageLevel1(), discount.getPercentageLevel2(), discount.getPercentageLevel3(), discount.getPercentageLevel4(), discount.getLimitationType(), GetterUtil.getInteger((Object)discount.getLimitationTimes()), GetterUtil.getBoolean((Object)discount.getActive()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), discount.getExternalReferenceCode(), GetterUtil.getBoolean((Object)discount.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = discount.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommerceDiscount.class, (long)commerceDiscount.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(discount, commerceDiscount, serviceContext);
    }
}

