/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0;

import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.DiscountProduct;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter.DiscountProductDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0.BaseDiscountProductResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.DiscountProductUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v1_0.DiscountProductResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/discount-product.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountProductResource.class})
public class DiscountProductResourceImpl
extends BaseDiscountProductResourceImpl {
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private DiscountProductDTOConverter _discountProductDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteDiscountProduct(Long id) throws Exception {
        this._commerceDiscountRelService.deleteCommerceDiscountRel(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<DiscountProduct> getDiscountByExternalReferenceCodeDiscountProductsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceDiscountRels = this._commerceDiscountRelService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), CPDefinition.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRelService.getCommerceDiscountRelsCount(commerceDiscount.getCommerceDiscountId(), CPDefinition.class.getName());
        return Page.of(this._toDiscountProducts(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<DiscountProduct> getDiscountIdDiscountProductsPage(Long id, Pagination pagination) throws Exception {
        List commerceDiscountRels = this._commerceDiscountRelService.getCommerceDiscountRels(id.longValue(), CPDefinition.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRelService.getCommerceDiscountRelsCount(id.longValue(), CPDefinition.class.getName());
        return Page.of(this._toDiscountProducts(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountProduct postDiscountByExternalReferenceCodeDiscountProduct(String externalReferenceCode, DiscountProduct discountProduct) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceDiscountRel commerceDiscountRel = DiscountProductUtil.addCommerceDiscountRel(this._cProductLocalService, this._commerceDiscountRelService, discountProduct, commerceDiscount, this._serviceContextHelper.getServiceContext());
        return this._toDiscountProduct(commerceDiscountRel.getCommerceDiscountRelId());
    }

    @Override
    public DiscountProduct postDiscountIdDiscountProduct(Long id, DiscountProduct discountProduct) throws Exception {
        CommerceDiscountRel commerceDiscountRel = DiscountProductUtil.addCommerceDiscountRel(this._cProductLocalService, this._commerceDiscountRelService, discountProduct, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper.getServiceContext());
        return this._toDiscountProduct(commerceDiscountRel.getCommerceDiscountRelId());
    }

    private DiscountProduct _toDiscountProduct(Long commerceDiscountRelId) throws Exception {
        return this._discountProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceDiscountRelId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<DiscountProduct> _toDiscountProducts(List<CommerceDiscountRel> commerceDiscountRels) throws Exception {
        ArrayList<DiscountProduct> discountProducts = new ArrayList<DiscountProduct>();
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            discountProducts.add(this._toDiscountProduct(commerceDiscountRel.getCommerceDiscountRelId()));
        }
        return discountProducts;
    }
}

