/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.DiscountCategory;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter.DiscountCategoryDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0.BaseDiscountCategoryResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.DiscountCategoryUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v1_0.DiscountCategoryResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/discount-category.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountCategoryResource.class})
public class DiscountCategoryResourceImpl
extends BaseDiscountCategoryResourceImpl {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private DiscountCategoryDTOConverter _discountCategoryDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteDiscountCategory(Long id) throws Exception {
        this._commerceDiscountRelService.deleteCommerceDiscountRel(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<DiscountCategory> getDiscountByExternalReferenceCodeDiscountCategoriesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceDiscountRels = this._commerceDiscountRelService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), AssetCategory.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRelService.getCommerceDiscountRelsCount(commerceDiscount.getCommerceDiscountId(), AssetCategory.class.getName());
        return Page.of(this._toDiscountCategories(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<DiscountCategory> getDiscountIdDiscountCategoriesPage(Long id, Pagination pagination) throws Exception {
        List commerceDiscountRels = this._commerceDiscountRelService.getCommerceDiscountRels(id.longValue(), AssetCategory.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRelService.getCommerceDiscountRelsCount(id.longValue(), AssetCategory.class.getName());
        return Page.of(this._toDiscountCategories(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountCategory postDiscountByExternalReferenceCodeDiscountCategory(String externalReferenceCode, DiscountCategory discountCategory) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceDiscountRel commerceDiscountRel = DiscountCategoryUtil.addCommerceDiscountRel(this._assetCategoryLocalService, this._commerceDiscountRelService, discountCategory, commerceDiscount, this._serviceContextHelper.getServiceContext());
        return this._toDiscountCategory(commerceDiscountRel.getCommerceDiscountRelId());
    }

    @Override
    public DiscountCategory postDiscountIdDiscountCategory(Long id, DiscountCategory discountCategory) throws Exception {
        CommerceDiscountRel commerceDiscountRel = DiscountCategoryUtil.addCommerceDiscountRel(this._assetCategoryLocalService, this._commerceDiscountRelService, discountCategory, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper.getServiceContext());
        return this._toDiscountCategory(commerceDiscountRel.getCommerceDiscountRelId());
    }

    private List<DiscountCategory> _toDiscountCategories(List<CommerceDiscountRel> commerceDiscountRels) throws Exception {
        ArrayList<DiscountCategory> discountCategories = new ArrayList<DiscountCategory>();
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            discountCategories.add(this._toDiscountCategory(commerceDiscountRel.getCommerceDiscountRelId()));
        }
        return discountCategories;
    }

    private DiscountCategory _toDiscountCategory(Long commerceDiscountRelId) throws Exception {
        return this._discountCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceDiscountRelId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

