/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceEntry;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.price.list.model.CommercePriceEntry"}, service={DTOConverter.class, PriceEntryDTOConverter.class})
public class PriceEntryDTOConverter
implements DTOConverter<CommercePriceEntry, PriceEntry> {
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;

    public String getContentType() {
        return PriceEntry.class.getSimpleName();
    }

    public PriceEntry toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getCommercePriceEntry(((Long)dtoConverterContext.getId()).longValue());
        CommercePriceList commercePriceList = commercePriceEntry.getCommercePriceList();
        final CommerceCurrency commerceCurrency = commercePriceList.getCommerceCurrency();
        final CPInstance cpInstance = commercePriceEntry.getCPInstance();
        final ExpandoBridge expandoBridge = commercePriceEntry.getExpandoBridge();
        final BigDecimal priceEntryPrice = commercePriceEntry.getPrice();
        final Locale locale = dtoConverterContext.getLocale();
        return new PriceEntry(){
            {
                this.actions = dtoConverterContext.getActions();
                this.bulkPricing = commercePriceEntry.isBulkPricing();
                this.customFields = expandoBridge.getAttributes();
                this.discountDiscovery = commercePriceEntry.isDiscountDiscovery();
                this.discountLevel1 = commercePriceEntry.getDiscountLevel1();
                this.discountLevel2 = commercePriceEntry.getDiscountLevel2();
                this.discountLevel3 = commercePriceEntry.getDiscountLevel3();
                this.discountLevel4 = commercePriceEntry.getDiscountLevel4();
                this.discountLevelsFormatted = PriceEntryDTOConverter.this._getDiscountLevelsFormatted(commercePriceEntry);
                this.displayDate = commercePriceEntry.getDisplayDate();
                this.expirationDate = commercePriceEntry.getExpirationDate();
                this.externalReferenceCode = commercePriceEntry.getExternalReferenceCode();
                this.hasTierPrice = commercePriceEntry.isHasTierPrice();
                this.id = commercePriceEntry.getCommercePriceEntryId();
                this.price = priceEntryPrice.doubleValue();
                this.priceFormatted = PriceEntryDTOConverter.this._formatPrice(priceEntryPrice, commerceCurrency, locale);
                this.priceListId = commercePriceEntry.getCommercePriceListId();
                this.skuExternalReferenceCode = cpInstance.getExternalReferenceCode();
                this.skuId = cpInstance.getCPInstanceId();
            }
        };
    }

    private String _formatPrice(BigDecimal price, CommerceCurrency commerceCurrency, Locale locale) throws Exception {
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        return this._commercePriceFormatter.format(commerceCurrency, price, locale);
    }

    private String _getDiscountLevelFormatted(BigDecimal discountLevel) {
        if (discountLevel == null) {
            return "";
        }
        return String.valueOf(discountLevel.doubleValue());
    }

    private String _getDiscountLevelsFormatted(CommercePriceEntry commercePriceEntry) {
        if (commercePriceEntry.isDiscountDiscovery() || commercePriceEntry.getDiscountLevel1() == null && commercePriceEntry.getDiscountLevel2() == null && commercePriceEntry.getDiscountLevel3() == null && commercePriceEntry.getDiscountLevel4() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._getDiscountLevelFormatted(commercePriceEntry.getDiscountLevel1()));
        sb.append(" - ");
        sb.append(this._getDiscountLevelFormatted(commercePriceEntry.getDiscountLevel2()));
        sb.append(" - ");
        sb.append(this._getDiscountLevelFormatted(commercePriceEntry.getDiscountLevel3()));
        sb.append(" - ");
        sb.append(this._getDiscountLevelFormatted(commercePriceEntry.getDiscountLevel4()));
        return sb.toString();
    }
}

